/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.event.events;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.ColorScheme;
import com.beatcraft.beatmap.data.EnvironmentColor;
import com.beatcraft.beatmap.data.object.BeatmapObject;
import com.beatcraft.data.types.Color;
import com.beatcraft.event.IEvent;
import com.beatcraft.lightshow.lights.LightState;
import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class LightEvent
extends BeatmapObject
implements IEvent {
    private static final float FADE_DURATION = 4.0f;
    private LightState lightState;
    private int lightEventType = 0;
    private float eventValue = 0.0f;
    private float duration = 0.0f;
    private int[] lightIDs;
    private Color chromaColor = null;
    private LightState fadeFrom = null;

    public void setFadeFrom(LightState from) {
        if (this.fadeFrom == null) {
            this.fadeFrom = from;
        }
    }

    public LightState getFaded(float t) {
        if (this.fadeFrom != null) {
            return this.fadeFrom.lerpFromTo(this.lightState, t);
        }
        return this.lightState;
    }

    @Override
    public float getEventBeat() {
        return this.getBeat();
    }

    @Override
    public float getEventDuration() {
        return this.duration;
    }

    public String toString() {
        return String.format("LightEvent[b:%s, v:%s, f:%s, d:%s]", Float.valueOf(this.getBeat()), this.lightEventType, Float.valueOf(this.eventValue), Float.valueOf(this.duration));
    }

    public boolean isFlashType() {
        return this.lightEventType == 2 || this.lightEventType == 6 || this.lightEventType == 10;
    }

    public boolean isFadeType() {
        return this.lightEventType == 3 || this.lightEventType == 7 || this.lightEventType == 11;
    }

    public boolean isTransitionType() {
        return this.lightEventType == 4 || this.lightEventType == 8 || this.lightEventType == 12;
    }

    @Override
    public LightEvent loadV2(JsonObject json, Difficulty difficulty) {
        super.loadV2(json, difficulty);
        this.lightEventType = JsonUtil.getOrDefault(json, "_value", JsonElement::getAsInt, Integer.valueOf(0));
        this.eventValue = JsonUtil.getOrDefault(json, "_floatValue", JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue();
        this.lightState = new LightState(new Color(0), 0.0f);
        JsonObject customData = JsonUtil.getOrDefault(json, "_customData", JsonElement::getAsJsonObject, null);
        if (customData != null) {
            JsonArray chromaColor;
            JsonArray lightIDs = JsonUtil.getOrDefault(customData, "_lightID", JsonElement::getAsJsonArray, null);
            if (lightIDs != null) {
                this.lightIDs = new int[lightIDs.size()];
                for (int i = 0; i < lightIDs.size(); ++i) {
                    int lightID;
                    this.lightIDs[i] = lightID = lightIDs.get(i).getAsInt();
                }
            }
            if ((chromaColor = (JsonArray)JsonUtil.getOrDefault(customData, "_color", JsonElement::getAsJsonArray, null)) != null) {
                this.chromaColor = Color.fromJsonArray(chromaColor);
            }
        }
        this.process(difficulty, this.lightState);
        return this;
    }

    private Color getColor(Difficulty difficulty, EnvironmentColor environmentColor) {
        ColorScheme colorScheme = difficulty.getSetDifficulty().getColorScheme();
        if (this.chromaColor != null) {
            return this.chromaColor;
        }
        return switch (environmentColor) {
            default -> throw new MatchException(null, null);
            case EnvironmentColor.LEFT -> colorScheme.getEnvironmentLeftColor().withAlpha(1.0f);
            case EnvironmentColor.RIGHT -> colorScheme.getEnvironmentRightColor().withAlpha(1.0f);
            case EnvironmentColor.WHITE -> colorScheme.getEnvironmentWhiteColor().withAlpha(1.0f);
        };
    }

    public boolean containsLightID(int lightID) {
        if (this.lightIDs == null) {
            return true;
        }
        for (int id : this.lightIDs) {
            if (id != lightID) continue;
            return true;
        }
        return false;
    }

    public LightState getLightState() {
        return this.lightState;
    }

    public void process(Difficulty difficulty, LightState lightState) {
        switch (this.lightEventType) {
            case 0: {
                lightState.setBrightness(0.0f);
                lightState.setColor(new Color(0));
                break;
            }
            case 1: {
                lightState.setColor(this.getColor(difficulty, EnvironmentColor.RIGHT));
                lightState.setBrightness(this.eventValue);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                lightState.setColor(this.getColor(difficulty, EnvironmentColor.RIGHT));
                lightState.setBrightness(this.eventValue);
                this.duration = 4.0f;
                break;
            }
            case 5: {
                lightState.setColor(this.getColor(difficulty, EnvironmentColor.LEFT));
                lightState.setBrightness(this.eventValue);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                lightState.setColor(this.getColor(difficulty, EnvironmentColor.LEFT));
                lightState.setBrightness(this.eventValue);
                this.duration = 4.0f;
                break;
            }
            case 9: {
                lightState.setColor(this.getColor(difficulty, EnvironmentColor.WHITE));
                lightState.setBrightness(this.eventValue);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                lightState.setColor(this.getColor(difficulty, EnvironmentColor.WHITE));
                lightState.setBrightness(this.eventValue);
                this.duration = 4.0f;
                break;
            }
        }
    }
}

