/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.event.events;

import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.beatmap.data.object.BeatmapObject;
import com.beatcraft.event.IEvent;
import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ValueEvent
extends BeatmapObject
implements IEvent {
    private int value = 0;
    private float duration = 0.0f;

    @Override
    public float getEventBeat() {
        return this.getBeat();
    }

    @Override
    public float getEventDuration() {
        return this.duration;
    }

    public String toString() {
        return String.format("ValueEvent[b:%s, v:%s, d:%s]", Float.valueOf(this.getBeat()), this.value, Float.valueOf(this.duration));
    }

    @Override
    public ValueEvent loadV2(JsonObject json, Difficulty difficulty) {
        super.loadV2(json, difficulty);
        this.value = JsonUtil.getOrDefault(json, "_value", JsonElement::getAsInt, Integer.valueOf(0));
        return this;
    }

    public int getValue() {
        return this.value;
    }
}

