/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.event.handlers;

import com.beatcraft.data.types.Color;
import com.beatcraft.event.EventHandler;
import com.beatcraft.lightshow.event.events.LightEvent;
import com.beatcraft.lightshow.lights.LightState;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class LightEventHandler
extends EventHandler<LightState, LightEvent> {
    public LightEventHandler(List<LightEvent> events) {
        super(events, new LightState(new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f));
    }

    @Override
    public void onEventInterrupted(LightEvent event, float normalTime) {
    }

    @Override
    public void onInsideEvent(LightEvent event, float normalTime) {
        LightState ls = event.getLightState();
        float fadeTime = 1.0f - (float)Math.pow(1.0f - normalTime, 3.0);
        if (event.isFlashType()) {
            float brightness = class_3532.method_16439((float)fadeTime, (float)1.2f, (float)1.0f);
            LightState s = ls.copy();
            s.setBrightness(brightness);
            this.state = s;
        } else if (event.isFadeType()) {
            float brightness = class_3532.method_16439((float)fadeTime, (float)1.2f, (float)0.0f);
            LightState s = ls.copy();
            s.setBrightness(brightness);
            this.state = s;
        } else if (event.isTransitionType()) {
            event.setFadeFrom((LightState)this.state);
            this.state = event.getFaded(normalTime);
        }
    }

    @Override
    public void onEventPassed(LightEvent event) {
        this.state = event.isFadeType() ? new LightState(new Color(0), 0.0f) : event.getLightState();
    }
}

