/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.lights;

import com.beatcraft.data.types.Color;
import com.beatcraft.lightshow.lights.LightState;
import com.beatcraft.render.effect.Bloomfog;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public abstract class LightObject {
    protected Vector3f position = new Vector3f();
    protected Quaternionf orientation = new Quaternionf();
    protected Vector3f offset = new Vector3f();
    protected Quaternionf rotation = new Quaternionf();
    protected Quaternionf worldRotation = new Quaternionf();
    protected LightState lightState = new LightState(new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f);

    public abstract void render(class_4587 var1, class_4184 var2, Bloomfog var3);

    public abstract void setBrightness(float var1);

    public abstract void setColor(int var1);

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setOrientation(Quaternionf orientation) {
        this.orientation = orientation;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation = rotation;
    }

    public void setWorldRotation(Quaternionf rotation) {
        this.worldRotation = rotation;
    }

    public Quaternionf getWorldRotation() {
        return this.worldRotation;
    }

    public void addRotation(Quaternionf rotation) {
        this.rotation.mul((Quaternionfc)rotation);
    }

    public void setLightState(LightState state) {
        this.lightState.setColor(new Color(state.getColor()));
        this.lightState.setBrightness(state.getBrightness());
    }

    public LightState getLightState() {
        return this.lightState;
    }

    public Vector3f getPos() {
        return new Vector3f((Vector3fc)this.position).rotate((Quaternionfc)this.rotation).add((Vector3fc)this.offset);
    }
}

