/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.lightshow.lights;

import com.beatcraft.data.types.Color;
import com.beatcraft.utils.MathUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class LightState {
    private Color color;
    private float brightness;
    private int effectiveColor = 0;

    public LightState(Color color, float brightness) {
        this.color = color;
        this.brightness = brightness;
        this.effectiveColor = this.calcEffectiveColor();
    }

    public LightState lerpFromTo(LightState to, float t) {
        Color c = MathUtil.lerpColor(this.color, to.color, t);
        float b = class_3532.method_16439((float)t, (float)this.brightness, (float)to.brightness);
        return new LightState(c, b);
    }

    public LightState lerpToFrom(LightState from, float t) {
        return from.lerpFromTo(this, t);
    }

    public LightState copy() {
        return new LightState(new Color(this.color.toARGB()), this.brightness);
    }

    private int calcEffectiveColor() {
        return this.color.lerpBrightness(this.brightness * 1.2f);
    }

    public int getEffectiveColor() {
        return this.effectiveColor;
    }

    public int getBloomColor() {
        return this.color.lerpBrightness(this.brightness);
    }

    public float getBrightness() {
        return this.brightness;
    }

    public int getColor() {
        return this.color.toARGB();
    }

    public void setColor(Color color) {
        this.color = color;
        this.effectiveColor = this.calcEffectiveColor();
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.effectiveColor = this.calcEffectiveColor();
    }

    private void set(Color color, float brightness) {
        this.color = color;
        this.brightness = brightness;
        this.effectiveColor = this.calcEffectiveColor();
    }

    public String toString() {
        return String.format("LightState{c:%s, b:%s}", Long.toString(this.getColor(), 16), Float.valueOf(this.brightness));
    }
}

