/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.logic;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class Hitbox {
    public Vector3f min;
    public Vector3f max;

    public Hitbox(Vector3f min, Vector3f max) {
        this.min = min;
        this.max = max;
    }

    public boolean checkCollision(Vector3f pointA, Vector3f pointB) {
        if (this.isPointInHitbox(pointA) || this.isPointInHitbox(pointB)) {
            return true;
        }
        Vector3f direction = new Vector3f((Vector3fc)pointB).sub((Vector3fc)pointA);
        Vector3f inverted = new Vector3f(1.0f / direction.x, 1.0f / direction.y, 1.0f / direction.z);
        float t1 = (this.min.x - pointA.x) * inverted.x;
        float t2 = (this.max.x - pointA.x) * inverted.x;
        float t3 = (this.min.y - pointA.y) * inverted.y;
        float t4 = (this.max.y - pointA.y) * inverted.y;
        float t5 = (this.min.z - pointA.z) * inverted.z;
        float t6 = (this.max.z - pointA.z) * inverted.z;
        float tMin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        float tMax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        return 0.0f <= tMax && tMin <= tMax && tMax <= 1.0f;
    }

    public Vector3f raycast(Vector3f pointA, Vector3f pointB) {
        if (this.isPointInHitbox(pointA)) {
            return new Vector3f((Vector3fc)pointA);
        }
        Vector3f direction = new Vector3f((Vector3fc)pointB).sub((Vector3fc)pointA);
        Vector3f inverted = new Vector3f(1.0f / direction.x, 1.0f / direction.y, 1.0f / direction.z);
        float t1 = (this.min.x - pointA.x) * inverted.x;
        float t2 = (this.max.x - pointA.x) * inverted.x;
        float t3 = (this.min.y - pointA.y) * inverted.y;
        float t4 = (this.max.y - pointA.y) * inverted.y;
        float t5 = (this.min.z - pointA.z) * inverted.z;
        float t6 = (this.max.z - pointA.z) * inverted.z;
        float tMin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        float tMax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        if (0.0f <= tMax && tMin <= tMax && tMax <= 1.0f) {
            return new Vector3f((Vector3fc)pointA).add((Vector3fc)new Vector3f((Vector3fc)direction).mul(tMin));
        }
        return null;
    }

    public boolean isPointInHitbox(Vector3f point) {
        return this.min.x <= point.x && point.x <= this.max.x && this.min.y <= point.y && point.y <= this.max.y && this.min.z <= point.z && point.z <= this.max.z;
    }
}

