/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.logic;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.render.DebugRenderer;
import com.beatcraft.render.object.PhysicalScorableObject;
import com.beatcraft.render.particle.BeatcraftParticleRenderer;
import java.util.ArrayDeque;
import java.util.Deque;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class SwingState {
    private final Deque<class_3545<Double, PhysicalScorableObject>> followThroughNotes = new ArrayDeque<class_3545<Double, PhysicalScorableObject>>();
    private final Deque<class_3545<Double, PhysicalScorableObject>> followThoughTemp = new ArrayDeque<class_3545<Double, PhysicalScorableObject>>();
    private final Vector3f lastPosition = new Vector3f();
    private final Quaternionf lastRotation = new Quaternionf();
    private final Vector3f endPoint = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f lastVelocity = new Vector3f();
    private float swingAngle = 0.0f;
    private double cutTime = 0.0;
    private boolean recentCut = false;
    private NoteType color;

    public SwingState(NoteType color) {
        this.color = color;
    }

    public Vector3f getVelocity(Vector3f currentPosition, Quaternionf currentRotation, double deltaTime) {
        Vector3f a = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)currentRotation).add((Vector3fc)currentPosition);
        this.endPoint.set((Vector3fc)a);
        Vector3f b = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.lastRotation).add((Vector3fc)this.lastPosition);
        Vector3f velocity = new Vector3f((Vector3fc)a).sub((Vector3fc)b).mul((float)deltaTime);
        if (DebugRenderer.doDebugRendering && DebugRenderer.debugSaberRendering) {
            DebugRenderer.renderLine(a, a.add((Vector3fc)velocity, new Vector3f()), -65536, -16776961);
        }
        return velocity;
    }

    private void processFollowThrough() {
        double t = (double)System.nanoTime() / 1.0E9;
        while (!this.followThroughNotes.isEmpty()) {
            class_3545<Double, PhysicalScorableObject> pair = this.followThroughNotes.pop();
            if (t - (Double)pair.method_15442() > 0.3) {
                ((PhysicalScorableObject)pair.method_15441()).score$getCutResult().setFollowThroughAngle((int)this.swingAngle - ((PhysicalScorableObject)pair.method_15441()).score$getCutResult().getPreSwingAngle());
                ((PhysicalScorableObject)pair.method_15441()).score$getCutResult().finalizeScore();
                ((PhysicalScorableObject)pair.method_15441()).score$cutNote();
                continue;
            }
            if (this.swingAngle - (float)((PhysicalScorableObject)pair.method_15441()).score$getCutResult().getPreSwingAngle() >= 60.0f) {
                ((PhysicalScorableObject)pair.method_15441()).score$getCutResult().setFollowThroughAngle(60);
                ((PhysicalScorableObject)pair.method_15441()).score$getCutResult().finalizeScore();
                ((PhysicalScorableObject)pair.method_15441()).score$cutNote();
            }
            this.followThoughTemp.add(pair);
        }
        this.followThroughNotes.addAll(this.followThoughTemp);
        this.followThoughTemp.clear();
    }

    private void createSparks(Vector3f pos, Vector3f velocity) {
        if (!BeatCraftClient.playerConfig.doSparkParticles() || BeatmapPlayer.currentBeatmap == null) {
            return;
        }
        int col = this.color == NoteType.RED ? BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB();
        BeatcraftParticleRenderer.spawnSparkParticles(pos, velocity.mul(0.1f, new Vector3f()), 0.2f, 0.03f, GameLogicHandler.random.nextInt(5, 15), col, 0.02f);
    }

    public void updateSaber(Vector3f position, Quaternionf orientation, double deltaTime) {
        Vector3f currentVelocity = this.getVelocity(position, orientation, deltaTime);
        if (this.recentCut) {
            double t = (double)System.nanoTime() / 1.0E9;
            if (t - 0.15 < this.cutTime) {
                this.createSparks(this.endPoint, currentVelocity);
            } else {
                this.recentCut = false;
            }
        }
        Quaternionf cv = new Quaternionf().lookAlong((Vector3fc)currentVelocity, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)).normalize();
        Quaternionf lv = new Quaternionf().lookAlong((Vector3fc)this.lastVelocity, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f)).normalize();
        float diff = 2.0f * Math.safeAcos((float)Math.min((float)Math.abs((float)cv.dot(lv)), (float)1.0f)) * 57.295776f;
        this.swingAngle += SwingState.angleBetween(orientation, this.lastRotation);
        if (diff > 46.0f) {
            this.swingAngle = 0.0f;
        }
        this.lastVelocity.set((Vector3fc)currentVelocity);
        this.lastPosition.set((Vector3fc)position);
        this.lastRotation.set((Quaternionfc)orientation);
        this.processFollowThrough();
    }

    public void startSparkEffect() {
        this.cutTime = (double)System.nanoTime() / 1.0E9;
        this.recentCut = true;
    }

    public static float angleBetween(Quaternionf q1, Quaternionf q2) {
        Quaternionf delta = new Quaternionf((Quaternionfc)q2).add((Quaternionfc)q1.invert(new Quaternionf()));
        return (float)Math.abs((double)Math.toDegrees((double)delta.angle()));
    }

    public float getSwingAngle() {
        return this.swingAngle;
    }

    public void followThrough(PhysicalScorableObject colorNote) {
        this.followThroughNotes.add((class_3545<Double, PhysicalScorableObject>)new class_3545((Object)((double)System.nanoTime() / 1.0E9), (Object)colorNote));
    }
}

