/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.animation.Easing;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.logic.Rank;
import com.beatcraft.menu.EndScreenData;
import com.beatcraft.menu.ModifierMenu;
import com.beatcraft.menu.SongSelectMenu;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.beatcraft.render.menu.ConfirmSongDeleteMenuPanel;
import com.beatcraft.render.menu.CreditsPanel;
import com.beatcraft.render.menu.EndScreenPanel;
import com.beatcraft.render.menu.ModifierMenuPanel;
import com.beatcraft.render.menu.PauseScreenPanel;
import com.beatcraft.render.menu.SettingsMenuPanel;
import com.beatcraft.render.menu.SongDownloaderMenuPanel;
import com.beatcraft.render.menu.SongSelectMenuPanel;
import com.beatcraft.render.particle.BeatcraftParticleRenderer;
import com.beatcraft.render.particle.MenuPointerParticle;
import com.beatcraft.render.particle.ScoreDisplay;
import com.beatcraft.utils.MathUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class HUDRenderer {
    public static MenuScene scene = MenuScene.SongSelect;
    public static NoteType pointerSaber = NoteType.BLUE;
    public static boolean triggerPressed = false;
    public static boolean triggerWasPressed = false;
    public static boolean showHUD = true;
    public static boolean advancedHUD = true;
    private static final Vector3f leftHudPosition = new Vector3f(3.0f, 1.0f, 0.0f);
    private static final Vector3f rightHudPosition = new Vector3f(-3.0f, 1.0f, 0.0f);
    private static final Vector3f healthBarPosition = new Vector3f(0.0f, -2.0f, 0.0f);
    private static final Quaternionf leftHudOrientation = new Quaternionf().rotateZ((float)Math.PI);
    private static final Quaternionf rightHudOrientation = new Quaternionf().rotateZ((float)Math.PI);
    private static final Quaternionf healthBarOrientation = new Quaternionf().rotateZ((float)Math.PI);
    private static final Function<Float, Float> opacityEasing = Easing.getEasing("easeInExpo");
    private static final class_327.class_6415 TEXT_LAYER = class_327.class_6415.field_33993;
    public static final int TEXT_COLOR = -1;
    public static final int TEXT_LIGHT = 255;
    public static final SongSelectMenu songSelectMenu = new SongSelectMenu();
    public static SongSelectMenuPanel songSelectMenuPanel = null;
    public static final PauseScreenPanel pauseScreenPanel = new PauseScreenPanel();
    public static final ModifierMenu modifierMenu = new ModifierMenu();
    private static final ModifierMenuPanel modifierMenuPanel = new ModifierMenuPanel(modifierMenu);
    public static final EndScreenPanel endScreenPanel = new EndScreenPanel(new EndScreenData(0, Rank.A, 0, 0, 0.0f, 0));
    public static ConfirmSongDeleteMenuPanel confirmSongDeleteMenuPanel = null;
    private static final SongDownloaderMenuPanel songDownloaderMenuPanel = new SongDownloaderMenuPanel();
    private static final SettingsMenuPanel settingsMenuPanel = new SettingsMenuPanel();
    private static final CreditsPanel creditsPanel = new CreditsPanel();
    public static class_4597 vertexConsumerProvider;

    public static void initSongSelectMenuPanel() {
        songSelectMenuPanel = new SongSelectMenuPanel(songSelectMenu);
    }

    public static void postScore(int score, Vector3f position, Vector3f endpoint, Quaternionf orientation) {
        if (!showHUD) {
            return;
        }
        BeatcraftParticleRenderer.addParticle(new ScoreDisplay(score, position, endpoint, orientation));
    }

    public static void render(class_4597 immediate) {
        vertexConsumerProvider = immediate;
        switch (scene.ordinal()) {
            case 0: {
                HUDRenderer.renderGameHud(immediate);
                break;
            }
            case 1: {
                HUDRenderer.renderSongSelectHud(immediate);
                break;
            }
            case 3: {
                HUDRenderer.renderSettings(immediate);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                HUDRenderer.renderDownloader(immediate);
                break;
            }
            case 5: {
                HUDRenderer.renderEndScreen(immediate);
                break;
            }
            case 6: {
                HUDRenderer.renderConfirmSongDelete(immediate);
                break;
            }
            case 7: {
                HUDRenderer.renderPauseScreen(immediate);
            }
        }
    }

    public static boolean isTriggerPressed() {
        boolean res = triggerPressed && !triggerWasPressed;
        triggerWasPressed = triggerPressed;
        return res;
    }

    public static void renderGameHud(class_4597 immediate) {
        if (!showHUD || BeatCraftClient.playerConfig.isModifierActive("Zen Mode")) {
            HUDRenderer.renderTime(null, null, null, null, null);
            return;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        class_327 textRenderer = class_310.method_1551().field_1772;
        Vector3f cameraPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        class_4587 matrices = new class_4587();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        matrices.method_22904(0.0, 0.0, 7.99);
        matrices.method_46416(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        matrices.method_22903();
        matrices.method_46416(HUDRenderer.leftHudPosition.x, HUDRenderer.leftHudPosition.y, HUDRenderer.leftHudPosition.z);
        matrices.method_22907(leftHudOrientation);
        matrices.method_22905(0.03125f, 0.03125f, 0.03125f);
        HUDRenderer.renderRank(matrices, textRenderer, buffer, cameraPos, immediate);
        HUDRenderer.renderCombo(matrices, textRenderer, buffer, cameraPos, immediate);
        HUDRenderer.renderScore(matrices, textRenderer, buffer, cameraPos, immediate);
        HUDRenderer.renderAccuracy(matrices, textRenderer, buffer, cameraPos, immediate);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416(HUDRenderer.rightHudPosition.x, HUDRenderer.rightHudPosition.y, HUDRenderer.rightHudPosition.z);
        matrices.method_22907(rightHudOrientation);
        matrices.method_22905(0.03125f, 0.03125f, 0.03125f);
        HUDRenderer.renderModifier(matrices, textRenderer, buffer, cameraPos, immediate);
        HUDRenderer.renderTime(matrices, textRenderer, buffer, cameraPos, immediate);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416(HUDRenderer.healthBarPosition.x, HUDRenderer.healthBarPosition.y, HUDRenderer.healthBarPosition.z);
        matrices.method_22907(healthBarOrientation);
        matrices.method_22905(0.03125f, 0.03125f, 0.03125f);
        HUDRenderer.renderPlayerHealth(matrices, textRenderer, buffer, cameraPos, immediate);
        matrices.method_22909();
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
        class_286.method_43433((class_9801)buff);
        RenderSystem.disableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private static void renderSongSelectHud(class_4597 immediate) {
        if (songSelectMenuPanel == null) {
            return;
        }
        Vector3f saberPos = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberPos : GameLogicHandler.leftSaberPos;
        Quaternionf saberRot = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberRotation : GameLogicHandler.leftSaberRotation;
        class_3545<Vector3f, Vector2f> pair = songSelectMenuPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), songSelectMenuPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        songSelectMenuPanel.render((class_4597.class_4598)immediate, local);
        pair = modifierMenuPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), modifierMenuPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        modifierMenuPanel.render((class_4597.class_4598)immediate, local);
        pair = creditsPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), creditsPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        creditsPanel.render((class_4597.class_4598)immediate, local);
    }

    private static void renderSettings(class_4597 immediate) {
        Vector3f saberPos = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberPos : GameLogicHandler.leftSaberPos;
        Quaternionf saberRot = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberRotation : GameLogicHandler.leftSaberRotation;
        class_3545<Vector3f, Vector2f> pair = settingsMenuPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), settingsMenuPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        settingsMenuPanel.render((class_4597.class_4598)immediate, local);
        pair = modifierMenuPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), modifierMenuPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        modifierMenuPanel.render((class_4597.class_4598)immediate, local);
        pair = creditsPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), creditsPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        creditsPanel.render((class_4597.class_4598)immediate, local);
    }

    private static void renderDownloader(class_4597 immediate) {
        Vector3f saberPos = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberPos : GameLogicHandler.leftSaberPos;
        Quaternionf saberRot = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberRotation : GameLogicHandler.leftSaberRotation;
        class_3545<Vector3f, Vector2f> pair = songDownloaderMenuPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), songDownloaderMenuPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        songDownloaderMenuPanel.render((class_4597.class_4598)immediate, local);
        pair = modifierMenuPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), modifierMenuPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        modifierMenuPanel.render((class_4597.class_4598)immediate, local);
        pair = creditsPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), creditsPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        creditsPanel.render((class_4597.class_4598)immediate, local);
    }

    private static void renderEndScreen(class_4597 immediate) {
        Vector3f saberPos = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberPos : GameLogicHandler.leftSaberPos;
        Quaternionf saberRot = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberRotation : GameLogicHandler.leftSaberRotation;
        class_3545<Vector3f, Vector2f> pair = endScreenPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), endScreenPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        endScreenPanel.render((class_4597.class_4598)immediate, local);
    }

    private static void renderConfirmSongDelete(class_4597 immediate) {
        if (confirmSongDeleteMenuPanel == null) {
            return;
        }
        Vector3f saberPos = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberPos : GameLogicHandler.leftSaberPos;
        Quaternionf saberRot = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberRotation : GameLogicHandler.leftSaberRotation;
        class_3545<Vector3f, Vector2f> pair = confirmSongDeleteMenuPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), confirmSongDeleteMenuPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        confirmSongDeleteMenuPanel.render((class_4597.class_4598)immediate, local);
    }

    private static void renderPauseScreen(class_4597 immediate) {
        Vector3f saberPos = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberPos : GameLogicHandler.leftSaberPos;
        Quaternionf saberRot = pointerSaber == NoteType.BLUE ? GameLogicHandler.rightSaberRotation : GameLogicHandler.leftSaberRotation;
        class_3545<Vector3f, Vector2f> pair = pauseScreenPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            HUDRenderer.spawnMenuPointerParticle((Vector3f)pair.method_15442(), pauseScreenPanel.getNormal());
            local = (Vector2f)pair.method_15441();
        }
        pauseScreenPanel.render((class_4597.class_4598)immediate, local);
    }

    private static void spawnMenuPointerParticle(Vector3f position, Vector3f normal) {
        BeatcraftParticleRenderer.addParticle(new MenuPointerParticle(position.add((Vector3fc)normal.mul(0.01f, new Vector3f()), new Vector3f()), normal));
    }

    private static void renderRank(class_4587 matrices, class_327 textRenderer, class_287 buffer, Vector3f cameraPos, class_4597 immediate) {
        String rank = GameLogicHandler.getRank().toString();
        int w = textRenderer.method_1727(rank);
        matrices.method_22903();
        matrices.method_22905(2.0f, 2.0f, 2.0f);
        textRenderer.method_30882((class_2561)class_2561.method_43470((String)rank), (float)(-w) / 2.0f, 12.0f, -1, false, matrices.method_23760().method_23761(), immediate, TEXT_LAYER, 0, 255);
        matrices.method_22909();
    }

    private static void renderCombo(class_4587 matrices, class_327 textRenderer, class_287 buffer, Vector3f cameraPos, class_4597 immediate) {
        int w = textRenderer.method_1727("COMBO");
        textRenderer.method_30882((class_2561)class_2561.method_43470((String)"COMBO"), (float)(-w) / 2.0f, -28.0f, -1, false, matrices.method_23760().method_23761(), immediate, TEXT_LAYER, 0, 255);
        matrices.method_22903();
        matrices.method_46416(0.0f, -31.0f, 0.0f);
        Vector3f topLine = matrices.method_23760().method_23761().getTranslation(new Vector3f());
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416(0.0f, -4.0f, 0.0f);
        Vector3f bottomLine = matrices.method_23760().method_23761().getTranslation(new Vector3f());
        matrices.method_22909();
        float op = opacityEasing.apply(Float.valueOf(GameLogicHandler.getComboBarOpacity())).floatValue();
        if (op > 0.0f) {
            float width = 0.5f * (1.0f / op);
            int color = 0xFFFFFF + ((int)(255.0f * op) << 24);
            buffer.method_22912(topLine.x + width, topLine.y, topLine.z).method_39415(color);
            buffer.method_22912(topLine.x + width, topLine.y + 0.05f, topLine.z).method_39415(color);
            buffer.method_22912(topLine.x - width, topLine.y + 0.05f, topLine.z).method_39415(color);
            buffer.method_22912(topLine.x - width, topLine.y, topLine.z).method_39415(color);
            buffer.method_22912(bottomLine.x + width, bottomLine.y, bottomLine.z).method_39415(color);
            buffer.method_22912(bottomLine.x + width, bottomLine.y + 0.05f, bottomLine.z).method_39415(color);
            buffer.method_22912(bottomLine.x - width, bottomLine.y + 0.05f, bottomLine.z).method_39415(color);
            buffer.method_22912(bottomLine.x - width, bottomLine.y, bottomLine.z).method_39415(color);
        }
        matrices.method_22903();
        matrices.method_22905(1.5f, 1.5f, 1.5f);
        String combo = String.valueOf(GameLogicHandler.getCombo());
        w = textRenderer.method_1727(combo);
        textRenderer.method_30882((class_2561)class_2561.method_43470((String)combo), (float)(-w) / 2.0f, -12.0f, -1, false, matrices.method_23760().method_23761(), immediate, TEXT_LAYER, 0, 255);
        matrices.method_22909();
    }

    private static void renderScore(class_4587 matrices, class_327 textRenderer, class_287 buffer, Vector3f cameraPos, class_4597 immediate) {
        String score = String.valueOf(GameLogicHandler.getScore());
        int w = textRenderer.method_1727(score);
        matrices.method_22903();
        matrices.method_22905(1.2f, 1.2f, 1.2f);
        textRenderer.method_30882((class_2561)class_2561.method_43470((String)score), (float)(-w) / 2.0f, 2.0f, -1, false, matrices.method_23760().method_23761(), immediate, TEXT_LAYER, 0, 255);
        matrices.method_22909();
    }

    private static void renderAccuracy(class_4587 matrices, class_327 textRenderer, class_287 buffer, Vector3f cameraPos, class_4597 immediate) {
        String accuracy = String.format("%.1f", Float.valueOf(GameLogicHandler.getAccuracy() * 100.0f)) + "%";
        int w = textRenderer.method_1727(accuracy);
        matrices.method_22903();
        matrices.method_22905(0.8f, 0.8f, 0.8f);
        textRenderer.method_30882((class_2561)class_2561.method_43470((String)accuracy), (float)(-w) / 2.0f, 18.0f, -1, false, matrices.method_23760().method_23761(), immediate, TEXT_LAYER, 0, 255);
        matrices.method_22909();
    }

    public static void drawArc(Vector3f center, Vector3f[] innerArc, class_287 buffer, int color) {
        for (int i = 0; i < innerArc.length - 1; ++i) {
            Vector3f a = innerArc[i];
            Vector3f b = innerArc[i + 1];
            Vector3f c = a.sub((Vector3fc)center, new Vector3f()).normalize().mul(0.05f).add((Vector3fc)a);
            Vector3f d = b.sub((Vector3fc)center, new Vector3f()).normalize().mul(0.05f).add((Vector3fc)b);
            buffer.method_22912(a.x, a.y, a.z).method_39415(color);
            buffer.method_22912(b.x, b.y, b.z).method_39415(color);
            buffer.method_22912(d.x, d.y, d.z).method_39415(color);
            buffer.method_22912(c.x, c.y, c.z).method_39415(color);
        }
    }

    private static void renderModifier(class_4587 matrices, class_327 textRenderer, class_287 buffer, Vector3f cameraPos, class_4597 immediate) {
        Vector3f[] arcPoints;
        String mod = String.valueOf(GameLogicHandler.getBonusModifier());
        textRenderer.method_30882((class_2561)class_2561.method_43470((String)"x"), -8.5f, -20.0f, -1, false, matrices.method_23760().method_23761(), immediate, TEXT_LAYER, 0, 255);
        matrices.method_22903();
        matrices.method_22905(2.5f, 2.5f, 2.5f);
        textRenderer.method_30882((class_2561)class_2561.method_43470((String)mod), -1.0f, -8.0f, -1, false, matrices.method_23760().method_23761(), immediate, TEXT_LAYER, 0, 255);
        matrices.method_22909();
        Vector3f center = matrices.method_23760().method_23761().getTranslation(new Vector3f()).add(0.0f, 0.375f, 0.0f);
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        float radius = 0.5f;
        float circleProgress = GameLogicHandler.getModifierPercentage();
        if (circleProgress > 0.0f) {
            arcPoints = MathUtil.generateCircle(normal, radius, 2 + (int)(circleProgress * 20.0f), center, 360.0f * circleProgress, 180.0f);
            HUDRenderer.drawArc(center, arcPoints, buffer, -1);
        }
        if (circleProgress < 1.0f) {
            arcPoints = MathUtil.generateCircle(normal, radius, 2 + (int)((1.0f - circleProgress) * 20.0f), center, 360.0f * (1.0f - circleProgress), 180.0f + 360.0f * circleProgress);
            HUDRenderer.drawArc(center, arcPoints, buffer, 0x7F7F7F7F);
        }
    }

    private static void renderTime(class_4587 matrices, class_327 textRenderer, class_287 buffer, Vector3f cameraPos, class_4597 immediate) {
        float songDuration = 0.0f;
        if (BeatmapPlayer.currentInfo != null) {
            songDuration = BeatmapPlayer.currentInfo.getSongDuration();
        }
        float t = BeatmapPlayer.getCurrentSeconds();
        String currentTime = MathUtil.timeToString((int)t);
        String length = MathUtil.timeToString((int)songDuration);
        float progress = MathUtil.inverseLerp(0.0f, songDuration, t);
        if (progress > 1.0f && BeatmapPlayer.currentInfo != null) {
            GameLogicHandler.triggerSongEnd();
        }
        if (!showHUD || BeatCraftClient.playerConfig.isModifierActive("Zen Mode")) {
            return;
        }
        String display = currentTime + " | " + length;
        int w = textRenderer.method_1727(display);
        Vector3f leftPos = matrices.method_23760().method_23761().getTranslation(new Vector3f()).add(0.65f, -0.4f, 0.0f);
        Vector3f rightPos = leftPos.add(-1.3f, 0.0f, 0.0f, new Vector3f());
        Vector3f midPos = MathUtil.lerpVector3(leftPos, rightPos, progress);
        buffer.method_22912(leftPos.x, leftPos.y, leftPos.z).method_39415(-1);
        buffer.method_22912(leftPos.x, leftPos.y + 0.05f, leftPos.z).method_39415(-1);
        buffer.method_22912(midPos.x, midPos.y + 0.05f, midPos.z).method_39415(-1);
        buffer.method_22912(midPos.x, midPos.y, midPos.z).method_39415(-1);
        buffer.method_22912(midPos.x, midPos.y, midPos.z).method_39415(0x7F7F7F7F);
        buffer.method_22912(midPos.x, midPos.y + 0.05f, midPos.z).method_39415(0x7F7F7F7F);
        buffer.method_22912(rightPos.x, rightPos.y + 0.05f, rightPos.z).method_39415(0x7F7F7F7F);
        buffer.method_22912(rightPos.x, rightPos.y, rightPos.z).method_39415(0x7F7F7F7F);
        matrices.method_22903();
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        textRenderer.method_30882((class_2561)class_2561.method_43470((String)display), (float)(-w) / 2.0f, 32.0f, -1, false, matrices.method_23760().method_23761(), immediate, TEXT_LAYER, 0, 255);
        matrices.method_22909();
    }

    private static void renderPlayerHealth(class_4587 matrices, class_327 textRenderer, class_287 buffer, Vector3f cameraPos, class_4597 immediate) {
        float progress = GameLogicHandler.getHealthPercentage();
        Vector3f leftPos = matrices.method_23760().method_23761().getTranslation(new Vector3f()).add(1.35f, 0.0f, 0.0f);
        Vector3f rightPos = new Vector3f(leftPos.x - 2.7f, leftPos.y, leftPos.z);
        Vector3f midPos = MathUtil.lerpVector3(leftPos, rightPos, progress);
        buffer.method_22912(leftPos.x, leftPos.y, leftPos.z).method_39415(-1);
        buffer.method_22912(leftPos.x, leftPos.y + 0.05f, leftPos.z).method_39415(-1);
        buffer.method_22912(midPos.x, midPos.y + 0.05f, midPos.z).method_39415(-1);
        buffer.method_22912(midPos.x, midPos.y, midPos.z).method_39415(-1);
        buffer.method_22912(midPos.x, midPos.y, midPos.z).method_39415(0x7F7F7F7F);
        buffer.method_22912(midPos.x, midPos.y + 0.05f, midPos.z).method_39415(0x7F7F7F7F);
        buffer.method_22912(rightPos.x, rightPos.y + 0.05f, rightPos.z).method_39415(0x7F7F7F7F);
        buffer.method_22912(rightPos.x, rightPos.y, rightPos.z).method_39415(0x7F7F7F7F);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum MenuScene {
        InGame,
        SongSelect,
        MainMenu,
        Settings,
        Downloader,
        EndScreen,
        ConfirmSongDelete,
        Paused;

    }
}

