/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.dynamic_loader;

import com.beatcraft.BeatCraft;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8215;

@Environment(value=EnvType.CLIENT)
public class DynamicTexture {
    private static final ArrayList<class_2960> loadedTextures = new ArrayList();
    private final class_2960 textureID;
    private final int width;
    private final int height;
    private final String path;
    private class_1011 img;
    private class_8215 tex;

    private String filterString(String in) {
        return in.replaceAll("[^a-z0-9/._-]", "_").replaceAll("(?i)\\.jpe?g$", ".png");
    }

    public DynamicTexture(String path) throws IOException {
        this.path = path.replaceAll("(?i)\\.jpe?g$", ".png");
        this.img = class_1011.method_4309((InputStream)new FileInputStream(this.path));
        this.tex = new class_1043(this.img);
        this.width = this.img.method_4307();
        this.height = this.img.method_4323();
        this.textureID = class_2960.method_60655((String)"beatcraft", (String)("dynamic/" + this.filterString(this.path.toLowerCase())));
        DynamicTexture.unloadTextureFromId(this.textureID);
        class_310.method_1551().method_1531().method_4616(this.textureID, (class_1044)this.tex);
        loadedTextures.add(this.textureID);
    }

    public void reload() {
        class_310.method_1551().method_1531().method_4615(this.textureID);
        try {
            this.img = class_1011.method_4309((InputStream)new FileInputStream(this.path));
            this.tex = new class_1043(this.img);
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to reload texture '{}'", (Object)this.path, (Object)e);
        }
        class_310.method_1551().method_1531().method_4616(this.textureID, (class_1044)this.tex);
        if (!loadedTextures.contains(this.textureID)) {
            loadedTextures.add(this.textureID);
        }
    }

    public boolean isLoaded() {
        return loadedTextures.contains(this.textureID);
    }

    public class_2960 id() {
        return this.textureID;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public static void unloadAllTextures() {
        for (class_2960 id : loadedTextures) {
            class_310.method_1551().method_1531().method_4615(id);
        }
        loadedTextures.clear();
    }

    public void unloadTexture() {
        if (!this.isLoaded()) {
            return;
        }
        class_310.method_1551().method_1531().method_4615(this.textureID);
        loadedTextures.remove(this.textureID);
    }

    public static void unloadTextureFromId(class_2960 id) {
        if (loadedTextures.contains(id)) {
            class_310.method_1551().method_1531().method_4615(id);
            loadedTextures.remove(id);
        }
    }
}

