/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.effect;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.Bloomfog;
import com.beatcraft.render.mesh.MeshLoader;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class MirrorHandler {
    private static Bloomfog mirrorBloomfog;
    public static Quaternionf invCameraRotation;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> plainMirrorCalls;
    private static final ArrayList<TriConsumer<class_287, Vector3f, Quaternionf>> drawCalls;
    private static final ArrayList<Bloomfog.QuadConsumer<class_287, Vector3f, Quaternionf, Boolean>> mirrorDraws;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> mirrorNotes;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> mirrorArrows;
    private static final ArrayList<BiConsumer<class_287, Vector3f>> mirrorWallGlows;
    private static final ArrayList<Runnable> earlyCalls;
    private static final ArrayList<TriConsumer<class_287, Vector3f, Integer>> obstacleRenderCalls;
    public static class_6367 mirrorFramebuffer;
    public static class_6367 depthFramebuffer;
    public static class_5944 mirrorShader;
    public static class_5944 mirrorPositionColorClip;

    public static void init() {
        class_1041 window = class_310.method_1551().method_22683();
        mirrorFramebuffer = new class_6367(window.method_4480(), window.method_4507(), true, class_310.field_1703);
        depthFramebuffer = new class_6367(window.method_4480(), window.method_4507(), true, class_310.field_1703);
        mirrorBloomfog = new Bloomfog(false);
        try {
            mirrorShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "light_mirror", class_290.field_1576);
            mirrorPositionColorClip = new class_5944((class_5912)class_310.method_1551().method_1478(), "position_color_clip", class_290.field_1576);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void resize() {
        class_1041 window = class_310.method_1551().method_22683();
        mirrorFramebuffer.method_1234(Math.max(1, window.method_4480()), Math.max(1, window.method_4507()), class_310.field_1703);
        depthFramebuffer.method_1234(Math.max(1, window.method_4480()), Math.max(1, window.method_4507()), class_310.field_1703);
        mirrorBloomfog.resize(Math.max(1, window.method_4480()), Math.max(1, window.method_4507()), false);
    }

    public static void recordMirrorLightDraw(Bloomfog.QuadConsumer<class_287, Vector3f, Quaternionf, Boolean> call) {
        mirrorDraws.add(call);
    }

    public static void recordMirrorNoteDraw(BiConsumer<class_287, Vector3f> call) {
        mirrorNotes.add(call);
    }

    public static void recordMirrorArrowDraw(BiConsumer<class_287, Vector3f> call) {
        mirrorArrows.add(call);
    }

    public static void recordMirrorLaserRenderCall(BiConsumer<class_287, Vector3f> call) {
        mirrorWallGlows.add(call);
    }

    public static void recordEarlyRenderCall(Runnable call) {
        earlyCalls.add(call);
    }

    public static void recordCall(TriConsumer<class_287, Vector3f, Quaternionf> call) {
        drawCalls.add(call);
    }

    public static void recordPlainCall(BiConsumer<class_287, Vector3f> call) {
        plainMirrorCalls.add(call);
    }

    public static void recordMirroredObstacleRenderCall(TriConsumer<class_287, Vector3f, Integer> call) {
        obstacleRenderCalls.add(call);
    }

    private static void renderEarly(class_289 tessellator, Vector3f cameraPos) {
        for (Runnable call : earlyCalls) {
            call.run();
        }
        earlyCalls.clear();
    }

    private static void renderObstacles(class_289 tessellator, Vector3f cameraPos) {
        if (BeatmapPlayer.currentBeatmap == null) {
            obstacleRenderCalls.clear();
            return;
        }
        int color = BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getObstacleColor().toARGB(0.15f);
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (TriConsumer<class_287, Vector3f, Integer> call : obstacleRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)color);
        }
        obstacleRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(class_757::method_34540);
            buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
    }

    private static void renderNotes(class_289 tessellator, Vector3f cameraPos) {
        class_287 triBuffer = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        int oldTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShader(() -> BeatCraftRenderer.noteShader);
        RenderSystem.setShaderTexture((int)0, (class_2960)MeshLoader.NOTE_TEXTURE);
        for (BiConsumer<class_287, Vector3f> renderCall : mirrorNotes) {
            try {
                renderCall.accept(triBuffer, cameraPos);
            }
            catch (Exception e) {
                BeatCraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        class_9801 triBuff = triBuffer.method_60794();
        if (triBuff != null) {
            class_286.method_43433((class_9801)triBuff);
        }
        triBuffer = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.setShader(() -> BeatCraftRenderer.arrowShader);
        RenderSystem.setShaderTexture((int)0, (class_2960)MeshLoader.ARROW_TEXTURE);
        for (BiConsumer<class_287, Vector3f> renderCall : mirrorArrows) {
            try {
                renderCall.accept(triBuffer, cameraPos);
            }
            catch (Exception e) {
                BeatCraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        triBuff = triBuffer.method_60794();
        if (triBuff != null) {
            class_286.method_43433((class_9801)triBuff);
        }
        RenderSystem.setShaderTexture((int)0, (int)oldTexture);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        mirrorNotes.clear();
        mirrorArrows.clear();
    }

    private static void renderFloorLights(class_289 tessellator, Vector3f cameraPos) {
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<class_287, Vector3f> call : mirrorWallGlows) {
            call.accept(buffer, cameraPos);
        }
        mirrorWallGlows.clear();
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
        class_286.method_43433((class_9801)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private static void renderForDepth(class_289 tessellator, Vector3f cameraPos) {
        depthFramebuffer.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
        depthFramebuffer.method_1230(class_310.field_1703);
        BeatCraftRenderer.bloomfog.overrideBuffer = true;
        BeatCraftRenderer.bloomfog.overrideFramebuffer = depthFramebuffer;
        depthFramebuffer.method_1235(true);
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (TriConsumer<class_287, Vector3f, Quaternionf> call : drawCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)invCameraRotation.conjugate(new Quaternionf()));
        }
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(class_757::method_34540);
            class_286.method_43433((class_9801)buff);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        }
        BeatCraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatCraftRenderer.bloomfog.overrideBuffer = false;
        depthFramebuffer.method_1240();
        class_310.method_1551().method_1522().method_1235(true);
    }

    public static void drawMirror() {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        Vector3f cameraPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        Matrix4f worldTransform = new Matrix4f();
        worldTransform.translate((Vector3fc)cameraPos);
        Quaternionf q = MemoryPool.newQuaternionf(invCameraRotation).conjugate();
        worldTransform.rotate((Quaternionfc)q);
        MemoryPool.release(q);
        MirrorHandler.renderForDepth(tessellator, cameraPos);
        for (BiConsumer<class_287, Vector3f> call : plainMirrorCalls) {
            call.accept(buffer, cameraPos);
        }
        plainMirrorCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(() -> Bloomfog.bloomfogPositionColor);
            Bloomfog.bloomfogPositionColor.method_35785("WorldTransform").method_1250(worldTransform);
            BeatCraftRenderer.bloomfog.loadTex();
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableCull();
        }
        mirrorFramebuffer.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
        mirrorFramebuffer.method_1230(class_310.field_1703);
        BeatCraftRenderer.bloomfog.overrideBuffer = true;
        BeatCraftRenderer.bloomfog.overrideFramebuffer = mirrorFramebuffer;
        mirrorFramebuffer.method_1235(true);
        MirrorHandler.renderEarly(tessellator, cameraPos);
        buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (Bloomfog.QuadConsumer<class_287, Vector3f, Quaternionf, Boolean> quadConsumer : mirrorDraws) {
            quadConsumer.accept(buffer, cameraPos, invCameraRotation, true);
        }
        mirrorDraws.clear();
        buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.setShader(() -> mirrorPositionColorClip);
            RenderSystem.setShaderTexture((int)0, (int)depthFramebuffer.method_30278());
            mirrorPositionColorClip.method_34583("Sampler0", (Object)depthFramebuffer.method_30278());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableCull();
            class_286.method_43433((class_9801)buff);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableCull();
        }
        MirrorHandler.renderNotes(tessellator, cameraPos);
        MirrorHandler.renderFloorLights(tessellator, cameraPos);
        MirrorHandler.renderObstacles(tessellator, cameraPos);
        BeatCraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatCraftRenderer.bloomfog.overrideBuffer = false;
        mirrorFramebuffer.method_1240();
        class_310.method_1551().method_1522().method_1235(true);
        buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (TriConsumer triConsumer : drawCalls) {
            triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)invCameraRotation.conjugate(new Quaternionf()));
        }
        drawCalls.clear();
        buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.setShader(() -> mirrorShader);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (int)mirrorFramebuffer.method_30277());
            mirrorShader.method_34583("Sampler0", (Object)mirrorFramebuffer.method_30277());
            RenderSystem.setShaderTexture((int)1, (int)mirrorFramebuffer.method_30278());
            mirrorShader.method_34583("Sampler1", (Object)mirrorFramebuffer.method_30278());
            RenderSystem.setShaderTexture((int)2, (int)BeatCraftRenderer.bloomfog.blurredBuffer.method_30277());
            mirrorShader.method_34583("Sampler2", (Object)BeatCraftRenderer.bloomfog.blurredBuffer.method_30277());
            mirrorShader.method_35785("WorldPos").method_34413(cameraPos);
            mirrorShader.method_35785("GameTime").method_1251(BeatCraftClient.random.method_43057());
            class_286.method_43433((class_9801)buff);
            RenderSystem.depthMask((boolean)false);
        }
    }

    static {
        invCameraRotation = new Quaternionf();
        plainMirrorCalls = new ArrayList();
        drawCalls = new ArrayList();
        mirrorDraws = new ArrayList();
        mirrorNotes = new ArrayList();
        mirrorArrows = new ArrayList();
        mirrorWallGlows = new ArrayList();
        earlyCalls = new ArrayList();
        obstacleRenderCalls = new ArrayList();
    }
}

