/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.effect;

import com.beatcraft.logic.Hitbox;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.MirrorHandler;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import org.apache.logging.log4j.util.BiConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ObstacleGlowRenderer {
    private static Vector3f[] buildEdge(Vector3f pos1, Vector3f pos2, Vector3f cameraPos) {
        Vector3f lineNormal = MemoryPool.newVector3f(pos1).sub((Vector3fc)pos2).normalize();
        Vector3f p1normal = MemoryPool.newVector3f(pos1).sub((Vector3fc)cameraPos).normalize();
        Vector3f p2normal = MemoryPool.newVector3f(pos2).sub((Vector3fc)cameraPos).normalize();
        Vector3f p1offset = MemoryPool.newVector3f(lineNormal).cross((Vector3fc)p1normal).normalize().mul(0.05f);
        Vector3f p2offset = lineNormal.cross((Vector3fc)p2normal).normalize().mul(0.05f);
        Vector3f[] out = new Vector3f[]{MemoryPool.newVector3f(pos1).add((Vector3fc)p1offset), MemoryPool.newVector3f(pos1).sub((Vector3fc)p1offset), MemoryPool.newVector3f(pos2).sub((Vector3fc)p2offset), MemoryPool.newVector3f(pos2).add((Vector3fc)p2offset)};
        MemoryPool.release(p1normal, p2normal, p1offset, p2offset);
        return out;
    }

    public static void render(Vector3f position, Quaternionf orientation, Hitbox bounds, int color) {
        BeatCraftRenderer.recordLaserRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(buffer, camera) -> ObstacleGlowRenderer._render(position, orientation, bounds, color, buffer, camera, false)));
    }

    public static void renderMirrored(Vector3f position, Quaternionf orientation, Hitbox bounds, int color) {
        Vector3f flippedPos = position.mul(1.0f, -1.0f, 1.0f);
        Quaternionf flippedOrientation = MemoryPool.newQuaternionf(-orientation.x, orientation.y, -orientation.z, orientation.w);
        MemoryPool.release(orientation);
        MirrorHandler.recordMirrorLaserRenderCall((buffer, camera) -> ObstacleGlowRenderer._render(flippedPos, flippedOrientation, bounds, color, buffer, camera, true));
    }

    public static void _render(Vector3f position, Quaternionf orientation, Hitbox bounds, int color, class_287 buffer, Vector3f cameraPos, boolean mirrored) {
        List<Vector3f[]> edges = BeatCraftRenderer.getCubeEdges(bounds.min, bounds.max);
        for (Vector3f[] edge : edges) {
            Vector3f e0 = MemoryPool.newVector3f(edge[0]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)position);
            Vector3f e1 = MemoryPool.newVector3f(edge[1]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)position);
            Vector3f[] mesh = ObstacleGlowRenderer.buildEdge(e0, e1, cameraPos);
            int fadeColor = 0xFFFFFF & color | 0x1000000;
            buffer.method_22912(e0.x - cameraPos.x, e0.y - cameraPos.y, e0.z - cameraPos.z).method_39415(-1);
            buffer.method_22912(e1.x - cameraPos.x, e1.y - cameraPos.y, e1.z - cameraPos.z).method_39415(-1);
            buffer.method_22912(mesh[3].x - cameraPos.x, mesh[3].y - cameraPos.y, mesh[3].z - cameraPos.z).method_39415(fadeColor);
            buffer.method_22912(mesh[0].x - cameraPos.x, mesh[0].y - cameraPos.y, mesh[0].z - cameraPos.z).method_39415(fadeColor);
            buffer.method_22912(e0.x - cameraPos.x, e0.y - cameraPos.y, e0.z - cameraPos.z).method_39415(-1);
            buffer.method_22912(e1.x - cameraPos.x, e1.y - cameraPos.y, e1.z - cameraPos.z).method_39415(-1);
            buffer.method_22912(mesh[2].x - cameraPos.x, mesh[2].y - cameraPos.y, mesh[2].z - cameraPos.z).method_39415(fadeColor);
            buffer.method_22912(mesh[1].x - cameraPos.x, mesh[1].y - cameraPos.y, mesh[1].z - cameraPos.z).method_39415(fadeColor);
            MemoryPool.release(e0, e1);
            MemoryPool.release(mesh);
        }
        MemoryPool.release(position);
        MemoryPool.release(orientation);
    }
}

