/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.effect;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.data.types.Color;
import com.beatcraft.lightshow.environment.Environment;
import com.beatcraft.utils.MathUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@net.fabricmc.api.Environment(value=EnvType.CLIENT)
public class SkyFogController {
    private static double last = 1.0;
    private static final double STEP = 0.01;
    private static final float dst = 10.0f;
    private static final float sq2 = 10.0f * (float)(Math.sqrt(2.0) / 2.0);
    private static final Vector3f[] offsets = new Vector3f[]{new Vector3f(-10.0f, 0.0f, 0.0f), new Vector3f(-sq2, 0.0f, -sq2), new Vector3f(0.0f, 0.0f, -10.0f), new Vector3f(sq2, 0.0f, -sq2), new Vector3f(10.0f, 0.0f, 0.0f), new Vector3f(sq2, 0.0f, sq2), new Vector3f(0.0f, 0.0f, 10.0f), new Vector3f(-sq2, 0.0f, sq2)};
    private static final Color blank = new Color(0);

    private static void stepTo(double target) {
        if (last == target) {
            return;
        }
        last = target > last ? Math.min(target, last + 0.01) : Math.max(target, last - 0.01);
    }

    public static double getColorModifier() {
        return last;
    }

    public static void updateColor() {
        boolean playing = BeatmapPlayer.isPlaying();
        double radius = playing ? 250.0 : 18.0;
        double outer = playing ? 75.0 : 6.0;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            SkyFogController.stepTo(1.0);
            return;
        }
        float dist = (float)player.method_19538().method_1022(new class_243(0.0, 0.0, 0.0));
        if ((double)dist <= radius) {
            SkyFogController.stepTo(0.0);
            return;
        }
        if ((double)dist <= radius + outer) {
            double delta = MathUtil.inverseLerp(radius, radius + outer, (double)dist);
            SkyFogController.stepTo(delta);
            return;
        }
        SkyFogController.stepTo(1.0);
    }

    public static Color getGradientColor(Color original) {
        Environment ls;
        Color c2 = Environment.DEFAULT_FOG_COLOR;
        Difficulty beatmap = BeatmapPlayer.currentBeatmap;
        if (beatmap != null && (ls = beatmap.lightShowEnvironment) != null) {
            c2 = ls.getFogColor();
        }
        return MathUtil.lerpColor(c2, original, (float)SkyFogController.getColorModifier());
    }

    private static Vector3f processVertex(Vector3f vIn, Quaternionf cameraRotation) {
        return vIn.rotate((Quaternionfc)cameraRotation, new Vector3f());
    }

    public static void render(class_287 buffer, Vector3f cameraPos, Quaternionf cameraRot) {
        Color color = SkyFogController.getGradientColor(blank);
        RenderSystem.depthMask((boolean)false);
        if ((color.toARGB() >> 24 & 0xFF) == 0) {
            return;
        }
        Vector3f a = offsets[7];
        for (Vector3f o : offsets) {
            for (float f = 0.0f; f < 0.12f; f += 0.03f) {
                Vector3f la = SkyFogController.processVertex(a.add(0.0f, f, 0.0f, new Vector3f()), cameraRot);
                Vector3f lo = SkyFogController.processVertex(o.add(0.0f, f, 0.0f, new Vector3f()), cameraRot);
                Vector3f n = la.sub((Vector3fc)lo, new Vector3f());
                buffer.method_60830(la).method_22914(n.x, n.y, n.z).method_39415(color.lerpBrightness(1.0f - f * 2.0f));
                buffer.method_60830(lo).method_22914(-n.x, -n.y, -n.z).method_39415(color.lerpBrightness(1.0f - f * 2.0f));
            }
            a = o;
        }
        RenderSystem.depthMask((boolean)true);
    }
}

