/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.lights;

import com.beatcraft.data.types.Color;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.lightshow.lights.LightState;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.RenderUtil;
import com.beatcraft.render.effect.Bloomfog;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class GlowingCuboid
extends LightObject {
    private Hitbox dimensions;
    private List<Vector3f[]> faces;
    private List<Vector3f[]> lines;

    public GlowingCuboid(Hitbox dimensions, Vector3f pos, Quaternionf rot) {
        this.position = pos;
        this.orientation = rot;
        this.setDimensions(dimensions);
        this.lightState = new LightState(new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f);
    }

    public GlowingCuboid cloneOffset(Vector3f offset) {
        return new GlowingCuboid(new Hitbox(new Vector3f((Vector3fc)this.dimensions.min), new Vector3f((Vector3fc)this.dimensions.max)), this.position.add((Vector3fc)offset, new Vector3f()), new Quaternionf((Quaternionfc)this.orientation));
    }

    public void setDimensions(Hitbox dimensions) {
        this.dimensions = dimensions;
        this.faces = BeatCraftRenderer.getCubeFaces(dimensions.min, dimensions.max);
        this.lines = BeatCraftRenderer.getCubeEdges(dimensions.min, dimensions.max);
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera, Bloomfog bloomfog) {
        Vector3f pos = new Vector3f((Vector3fc)this.position);
        Vector3f off = new Vector3f((Vector3fc)this.offset);
        Quaternionf ori = new Quaternionf((Quaternionfc)this.orientation);
        Quaternionf rot = new Quaternionf((Quaternionfc)this.rotation);
        Quaternionf wrot = new Quaternionf((Quaternionfc)this.worldRotation);
        LightState state = this.lightState.copy();
        if (bloomfog != null) {
            bloomfog.record((b, c, r, m) -> this._render((class_287)b, (Vector3f)c, true, (Quaternionf)r, ori, rot, wrot, pos, off, state, (boolean)m));
            bloomfog.recordBloomCall((TriConsumer<class_287, Vector3f, Quaternionf>)((TriConsumer)(b, v, q) -> this._renderBloom((class_287)b, (Vector3f)v, (Quaternionf)q, ori, rot, wrot, pos, off, state)));
        }
        BeatCraftRenderer.recordLightRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(b, c) -> this._render((class_287)b, (Vector3f)c, false, null, ori, rot, wrot, pos, off, state, false)));
    }

    private Quaternionf mirrorQuaternion(boolean mirror, Quaternionf quat) {
        return mirror ? new Quaternionf(-quat.x, quat.y, -quat.z, quat.w) : quat;
    }

    private Vector3f processVertex(Vector3f basePos, Vector3f cameraPos, Quaternionf orientation, Quaternionf rotation, Quaternionf worldRotation, Vector3f position, Vector3f offset, boolean mirrorDraw) {
        return basePos.mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).rotate((Quaternionfc)this.mirrorQuaternion(mirrorDraw, orientation)).rotate((Quaternionfc)this.mirrorQuaternion(mirrorDraw, rotation)).add((Vector3fc)position.mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f())).rotate((Quaternionfc)this.mirrorQuaternion(mirrorDraw, worldRotation)).add((Vector3fc)offset.mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f())).sub((Vector3fc)cameraPos);
    }

    private void _renderBloom(class_287 buffer, Vector3f cameraPos, Quaternionf cameraRotation, Quaternionf orientation, Quaternionf rotation, Quaternionf worldRotation, Vector3f position, Vector3f offset, LightState lightState) {
        int color = lightState.getBloomColor();
        if ((color >> 24 & 0xFF) == 0) {
            return;
        }
        for (Vector3f[] face : this.faces) {
            Vector3f v0 = this.processVertex(face[0], cameraPos, orientation, rotation, worldRotation, position, offset, false);
            Vector3f v1 = this.processVertex(face[1], cameraPos, orientation, rotation, worldRotation, position, offset, false);
            Vector3f v2 = this.processVertex(face[2], cameraPos, orientation, rotation, worldRotation, position, offset, false);
            Vector3f v3 = this.processVertex(face[3], cameraPos, orientation, rotation, worldRotation, position, offset, false);
            v0.rotate((Quaternionfc)cameraRotation);
            v1.rotate((Quaternionfc)cameraRotation);
            v2.rotate((Quaternionfc)cameraRotation);
            v3.rotate((Quaternionfc)cameraRotation);
            buffer.method_60830(v0).method_39415(color);
            buffer.method_60830(v1).method_39415(color);
            buffer.method_60830(v2).method_39415(color);
            buffer.method_60830(v0).method_39415(color);
            buffer.method_60830(v2).method_39415(color);
            buffer.method_60830(v3).method_39415(color);
        }
    }

    private void _render(class_287 buffer, Vector3f cameraPos, boolean isBloomfog, Quaternionf cameraRotation, Quaternionf orientation, Quaternionf rotation, Quaternionf worldRotation, Vector3f position, Vector3f offset, LightState lightState, boolean mirrorDraw) {
        int color;
        int n = color = isBloomfog ? lightState.getBloomColor() : lightState.getEffectiveColor();
        if ((color >> 24 & 0xFF) == 0) {
            return;
        }
        if (isBloomfog && !mirrorDraw) {
            for (Vector3f[] line : this.lines) {
                Vector3f v0 = this.processVertex(line[0], cameraPos, orientation, rotation, worldRotation, position, offset, false);
                Vector3f v1 = this.processVertex(line[1], cameraPos, orientation, rotation, worldRotation, position, offset, false);
                v0.rotate((Quaternionfc)cameraRotation);
                v1.rotate((Quaternionfc)cameraRotation);
                Vector3f n2 = v1.sub((Vector3fc)v0, new Vector3f());
                List<Vector3f[]> segments = RenderUtil.chopEdge(v0, v1);
                for (Vector3f[] segment : segments) {
                    buffer.method_60830(segment[0]).method_39415(color).method_22914(n2.x, n2.y, n2.z);
                    buffer.method_60830(segment[1]).method_39415(color).method_22914(-n2.x, -n2.y, -n2.z);
                }
            }
        } else {
            for (Vector3f[] face : this.faces) {
                Vector3f v0 = this.processVertex(face[0], cameraPos, orientation, rotation, worldRotation, position, offset, mirrorDraw);
                Vector3f v1 = this.processVertex(face[1], cameraPos, orientation, rotation, worldRotation, position, offset, mirrorDraw);
                Vector3f v2 = this.processVertex(face[2], cameraPos, orientation, rotation, worldRotation, position, offset, mirrorDraw);
                Vector3f v3 = this.processVertex(face[3], cameraPos, orientation, rotation, worldRotation, position, offset, mirrorDraw);
                buffer.method_60830(v0).method_39415(color);
                buffer.method_60830(v1).method_39415(color);
                buffer.method_60830(v2).method_39415(color);
                buffer.method_60830(v3).method_39415(color);
            }
        }
    }

    @Override
    public void setBrightness(float value) {
        this.lightState.setBrightness(value);
    }

    @Override
    public void setColor(int color) {
        this.lightState.setColor(new Color(color));
    }
}

