/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.menu;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.audio.BeatmapAudioPlayer;
import com.beatcraft.data.types.Stash;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.logic.InputSystem;
import com.beatcraft.menu.ModifierMenu;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.menu.MenuPanel;
import com.beatcraft.render.menu.SettingsMenuPanel;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.vivecraft.client_vr.ClientDataHolderVR;

@Environment(value=EnvType.CLIENT)
public class ModifierMenuPanel
extends MenuPanel<ModifierMenu> {
    private SongSelectPage currentPage = SongSelectPage.Modifiers;
    private final MenuPanel.ContainerWidget modifierPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget playerOptionsPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget settingsPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget downloaderPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget replayPage = new MenuPanel.ContainerWidget(new Vector3f(0.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final HashMap<String, MenuPanel.ToggleWidget> toggles = new HashMap();

    public ModifierMenuPanel(ModifierMenu data) {
        super(data);
        float angle = 1.0471976f;
        this.position.set(0.0f, 2.0f, 6.4f);
        this.position.rotateY(angle);
        this.orientation.set((Quaternionfc)new Quaternionf().rotateY(angle));
        this.size.set(800.0f, 500.0f);
        this.backgroundColor = 0;
        this.initLayout();
        this.toggleModifiers(BeatCraftClient.playerConfig.getActiveModifiers());
    }

    private void initLayout() {
        int BUTTON_COUNT = 5;
        this.widgets.addAll(List.of(this.getOptionButton("Modifiers", 0, BUTTON_COUNT, this::setModifierPage, SongSelectPage.Modifiers), this.getOptionButton("Player Options", 1, BUTTON_COUNT, this::setPlayerOptionsPage, SongSelectPage.PlayerOptions), this.getOptionButton("Settings", 2, BUTTON_COUNT, this::setSettingsPage, SongSelectPage.Settings), this.getOptionButton("BeatSaver", 3, BUTTON_COUNT, this::setDownloaderPage, SongSelectPage.Downloader), this.getOptionButton("Replay", 4, BUTTON_COUNT, this::setReplayPage, SongSelectPage.Replay)));
        this.modifierPage.children.addAll(List.of(this.getModifierToggle("No Fail", 0, 0, this::toggleNoFail, "1 Life", "4 Lives", "Zen Mode"), this.getModifierToggle("1 Life", 0, 1, this::toggle1Life, "No Fail", "4 Lives", "Zen Mode"), this.getModifierToggle("4 Lives", 0, 2, this::toggle4Lives, "No Fail", "1 Life", "Zen Mode"), this.getModifierToggle("No Bombs", 1, 0, this::toggleNoBombs, "Zen Mode"), this.getModifierToggle("No Walls", 1, 1, this::toggleNoObstacles, "Zen Mode")));
        this.modifierPage.children.addAll(List.of(this.getModifierToggle("Zen Mode", 3, 2, this::toggleZenMode, "No Fail", "1 Life", "4 Lives", "No Bombs", "No Walls", "No Arrows", "Ghost Notes", "Disappearing Arrows", "Small Notes", "Pro Mode", "Strict Angles"), this.getModifierToggle("Slower Song", 4, 0, this::toggleSlowerSong, "Faster Song", "Super Fast Song"), this.getModifierToggle("Faster Song", 4, 1, this::toggleFasterSong, "Slower Song", "Super Fast Song"), this.getModifierToggle("Super Fast Song", 4, 2, this::toggleSuperFastSong, "Slower Song", "Faster Song")));
        this.playerOptionsPage.children.addAll(List.of(SettingsMenuPanel.getOptionModifier("Reduced Debris", () -> BeatCraftClient.playerConfig.setReducedDebris(false), () -> BeatCraftClient.playerConfig.setReducedDebris(true), () -> BeatCraftClient.playerConfig.isReducedDebris() ? "ON" : "OFF", new Vector3f(-100.0f, -175.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Particles", () -> BeatCraftClient.playerConfig.setSparkParticles(false), () -> BeatCraftClient.playerConfig.setSparkParticles(true), () -> BeatCraftClient.playerConfig.doSparkParticles() ? "ON" : "OFF", new Vector3f(-100.0f, -123.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Trail Intensity", () -> Stash.updateTrailSize(Math.max(10, Stash.getTrailSize() - 10)), () -> Stash.updateTrailSize(Math.min(200, Stash.getTrailSize() + 10)), () -> String.valueOf(Stash.getTrailSize()), new Vector3f(-100.0f, -71.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Show Arms", () -> {
            ClientDataHolderVR.getInstance().vrSettings.showPlayerHands = false;
        }, () -> {
            ClientDataHolderVR.getInstance().vrSettings.showPlayerHands = true;
        }, () -> ClientDataHolderVR.getInstance().vrSettings.showPlayerHands ? "SHOW" : "HIDE", new Vector3f(-100.0f, -19.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Show Hotbar", () -> {
            class_310.method_1551().field_1690.field_1842 = true;
        }, () -> {
            class_310.method_1551().field_1690.field_1842 = false;
        }, () -> class_310.method_1551().field_1690.field_1842 ? "HIDE" : "SHOW", new Vector3f(-100.0f, 32.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Movement Lock", InputSystem::unlockMovement, InputSystem::lockMovement, () -> InputSystem.isMovementLocked() ? "ON" : "OFF", new Vector3f(-100.0f, 84.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Show HUD", () -> {
            HUDRenderer.showHUD = false;
        }, () -> {
            HUDRenderer.showHUD = true;
        }, () -> HUDRenderer.showHUD ? "SHOW" : "HIDE", new Vector3f(230.0f, -175.0f, 0.0f))));
        this.settingsPage.children.addAll(List.of(SettingsMenuPanel.getOptionModifier("Volume", () -> this.updateVolume((int)(BeatCraftClient.playerConfig.getVolume() * 100.0f) - 5), () -> this.updateVolume((int)(BeatCraftClient.playerConfig.getVolume() * 100.0f) + 5), this::getVolume, new Vector3f(-100.0f, -175.0f, 0.0f)), SettingsMenuPanel.getOptionModifier("Place Environments", () -> BeatCraftClient.playerConfig.setEnvironmentPlacing(false), () -> BeatCraftClient.playerConfig.setEnvironmentPlacing(true), () -> BeatCraftClient.playerConfig.doEnvironmentPlacing() ? "ON" : "OFF", new Vector3f(-100.0f, -123.0f, 0.0f))));
        this.downloaderPage.children.add(new MenuPanel.TextWidget("Go to Settings > Options > Beatcraft > Beatsaver", new Vector3f(0.0f, -11.0f, -0.01f), 3.0f));
        this.replayPage.children.add(new MenuPanel.TextWidget("COMING SOON", new Vector3f(0.0f, -11.0f, -0.01f), 3.0f));
    }

    private MenuPanel.Widget getOptionButton(String label, int index, int count, Runnable onClick, SongSelectPage page) {
        int AVAILABLE_WIDTH = 750;
        int widgetWidth = AVAILABLE_WIDTH / count;
        int widgetX = -(count * widgetWidth) / 2 + index * widgetWidth + widgetWidth / 2;
        return new MenuPanel.ButtonWidget(new Vector3f((float)widgetX, -225.0f, 0.01f), new Vector2f((float)widgetWidth, 40.0f), onClick, new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), List.of(new MenuPanel.DynamicGradientWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), () -> page == this.currentPage ? 0x5F444444 : 0x5F222222, () -> page == this.currentPage ? 0x5F444444 : 0x5F222222, 0.0f)), List.of(new MenuPanel.DynamicGradientWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), () -> page == this.currentPage ? 0x5F888888 : 0x5F666666, () -> page == this.currentPage ? 0x5F888888 : 0x5F666666, 0.0f))), new MenuPanel.TextWidget(label, new Vector3f(0.0f, -10.0f, 0.05f)).withScale(2.0f));
    }

    private Consumer<Boolean> getExclusionHandler(String label, Consumer<Boolean> toggleHandler, String ... exclusive) {
        return b -> {
            if (b.booleanValue()) {
                for (String exclude : exclusive) {
                    if (this.toggles.containsKey(exclude)) {
                        this.toggles.get(exclude).setState(false);
                        continue;
                    }
                    BeatCraft.LOGGER.error("Missing exclusive modifier: '{}'", (Object)exclude);
                }
            }
            BeatCraftClient.playerConfig.setModifier(label, (boolean)b);
            toggleHandler.accept((Boolean)b);
        };
    }

    private MenuPanel.Widget getModifierToggle(String label, int row, int column, Consumer<Boolean> toggleHandler, String ... exclusive) {
        boolean CENTER_X = false;
        int CENTER_Y = 120;
        int MAX_WIDTH = 750;
        int MAX_HEIGHT = 400;
        int COLUMNS = 3;
        int widget_height = 64;
        int widget_width = MAX_WIDTH / COLUMNS;
        float x = (float)CENTER_X + ((float)column - (float)(COLUMNS - 1) / 2.0f) * (float)widget_width;
        float y = (float)CENTER_Y - ((float)MAX_HEIGHT / 2.0f - (float)(row * widget_height));
        MenuPanel.ToggleWidget toggle = new MenuPanel.ToggleWidget(new Vector3f(0.0f, 0.0f, 0.0f), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), List.of(new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), 1594962841, 1594962841, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), 1594966988, 1594966988, 0.0f)))), List.of(new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), 0x5F222222, 0x5F222222, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((float)(widget_width - 4), (float)(widget_height - 4)), 0x5F666666, 0x5F666666, 0.0f)))), this.getExclusionHandler(label, toggleHandler, exclusive));
        this.toggles.put(label, toggle);
        return new MenuPanel.ContainerWidget(new Vector3f(x, y, 0.0f), new Vector2f((float)widget_width, (float)widget_height), toggle, new MenuPanel.TextWidget(label, new Vector3f(0.0f, -9.0f, 0.05f)).withScale(1.5f));
    }

    private void setModifierPage() {
        this.currentPage = SongSelectPage.Modifiers;
        HUDRenderer.scene = HUDRenderer.MenuScene.SongSelect;
    }

    private void setPlayerOptionsPage() {
        this.currentPage = SongSelectPage.PlayerOptions;
        HUDRenderer.scene = HUDRenderer.MenuScene.SongSelect;
    }

    private void setSettingsPage() {
        this.currentPage = SongSelectPage.Settings;
        HUDRenderer.scene = HUDRenderer.MenuScene.Settings;
    }

    private void setDownloaderPage() {
        this.currentPage = SongSelectPage.Downloader;
        HUDRenderer.scene = HUDRenderer.MenuScene.Downloader;
    }

    private void setReplayPage() {
        this.currentPage = SongSelectPage.Replay;
        HUDRenderer.scene = HUDRenderer.MenuScene.SongSelect;
    }

    public void toggleModifiers(List<String> modifiers) {
        modifiers.forEach(this::_toggleModifier);
    }

    private void _toggleModifier(String mod) {
        Consumer<Boolean> a = switch (mod) {
            case "No Fail" -> this::toggleNoFail;
            case "1 Life" -> this::toggle1Life;
            case "4 Lives" -> this::toggle4Lives;
            case "Slower Song" -> this::toggleSlowerSong;
            case "Faster Song" -> this::toggleFasterSong;
            case "Super Fast Song" -> this::toggleSuperFastSong;
            default -> b -> {};
        };
        this.toggles.get(mod).setState(true);
        a.accept(true);
    }

    private void toggleNoFail(boolean state) {
        GameLogicHandler.noFail = state;
    }

    private void toggle1Life(boolean state) {
        GameLogicHandler.maxHealth = state ? 1 : 100;
        GameLogicHandler.health = state ? 1.0f : 50.0f;
    }

    private void toggle4Lives(boolean state) {
        GameLogicHandler.maxHealth = state ? 4 : 100;
        GameLogicHandler.health = state ? 4.0f : 50.0f;
    }

    private void toggleNoBombs(boolean state) {
    }

    private void toggleNoObstacles(boolean state) {
    }

    private void toggleNoArrows(boolean state) {
    }

    private void toggleGhostNotes(boolean state) {
    }

    private void toggleDisappearingArrows(boolean state) {
    }

    private void toggleSmallNotes(boolean state) {
    }

    private void toggleProMode(boolean state) {
    }

    private void toggleStrictAngles(boolean state) {
    }

    private void toggleZenMode(boolean state) {
    }

    private void toggleSlowerSong(boolean state) {
        BeatmapPlayer.setPlaybackSpeed(state ? 0.85f : 1.0f);
    }

    private void toggleFasterSong(boolean state) {
        BeatmapPlayer.setPlaybackSpeed(state ? 1.2f : 1.0f);
    }

    private void toggleSuperFastSong(boolean state) {
        BeatmapPlayer.setPlaybackSpeed(state ? 1.5f : 1.0f);
    }

    private void updateVolume(int percent) {
        percent = Math.clamp((long)percent, 0, 100);
        BeatmapAudioPlayer.beatmapAudio.setVolume((float)percent / 100.0f);
        BeatCraftClient.playerConfig.setVolume((float)percent / 100.0f);
    }

    private String getVolume() {
        return String.format("%.0f", Float.valueOf(BeatCraftClient.playerConfig.getVolume() * 100.0f));
    }

    @Override
    public void render(class_4597.class_4598 immediate, Vector2f pointerPosition) {
        class_332 context = new class_332(class_310.method_1551(), immediate);
        Vector3f camPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        context.translate(-camPos.x, -camPos.y, -camPos.z);
        context.translate(this.position.x, this.position.y, this.position.z);
        context.multiply(this.orientation);
        context.scale(0.0078125f, 0.0078125f, 0.0078125f);
        context.push();
        context.method_25294((int)(-this.size.x / 2.0f), (int)(-this.size.y / 2.0f), (int)(this.size.x / 2.0f), (int)(this.size.y / 2.0f), this.backgroundColor);
        this.widgets.forEach(w -> w.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f())));
        switch (this.currentPage.ordinal()) {
            case 0: {
                this.modifierPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()));
                break;
            }
            case 1: {
                this.playerOptionsPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()));
                break;
            }
            case 2: {
                this.settingsPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()));
                break;
            }
            case 3: {
                this.downloaderPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()));
                break;
            }
            case 4: {
                this.replayPage.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()));
            }
        }
        context.method_51452();
        context.pop();
    }

    @Environment(value=EnvType.CLIENT)
    private static enum SongSelectPage {
        Modifiers,
        PlayerOptions,
        Settings,
        Downloader,
        Replay;

    }
}

