/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.menu;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.audio.BeatmapAudioPlayer;
import com.beatcraft.data.menu.SongData;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.logic.InputSystem;
import com.beatcraft.menu.ConfirmSongDeleteMenu;
import com.beatcraft.menu.SongSelectMenu;
import com.beatcraft.networking.c2s.MapSyncC2SPayload;
import com.beatcraft.networking.c2s.PlaceEnvironmentStructureC2SPayload;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.dynamic_loader.DynamicTexture;
import com.beatcraft.render.menu.ConfirmSongDeleteMenuPanel;
import com.beatcraft.render.menu.MenuPanel;
import com.beatcraft.render.menu.SettingsMenuPanel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_407;
import net.minecraft.class_8710;
import org.joml.Vector2f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class SongSelectMenuPanel
extends MenuPanel<SongSelectMenu> {
    private static final int SONGS_PER_PAGE = 6;
    private static final float PREVIEW_FADE_TIME = 1.2f;
    private static final int LIST_MAX_WIDTH = 110;
    private static final int DISPLAY_MAX_WIDTH = 110;
    private static SongData currentDisplay = null;
    private static class_2960 textureId = null;
    private static DynamicTexture currentCover = null;
    private static String selectedSet = "Standard";
    private static String selectedDiff = "ExpertPlus";
    private int scrollIndex = 0;
    private final MenuPanel.ContainerWidget songListContainer = new MenuPanel.ContainerWidget(new Vector3f(-350.0f, -200.0f, -0.01f), new Vector2f(300.0f, 500.0f), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget songDisplay = new MenuPanel.ContainerWidget(new Vector3f(200.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget setDifficulties = new MenuPanel.ContainerWidget(new Vector3f(200.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget difficultyStats = new MenuPanel.ContainerWidget(new Vector3f(200.0f, 0.0f, -0.01f), new Vector2f(), new MenuPanel.Widget[0]);
    private CompletableFuture<Void> song_play_request = null;

    public SongSelectMenuPanel(SongSelectMenu data) {
        super(data);
        this.backgroundColor = 0;
        this.position.set(0.1f, 2.0f, 6.0f);
        this.size.set(1000.0f, 500.0f);
        this.initLayout();
    }

    private void scrollDown() {
        this.scrollIndex = Math.min(this.scrollIndex + 1, BeatCraftClient.songs.getSongs().size() / 6);
        this.updateList();
        if (currentCover != null) {
            currentCover.reload();
        }
    }

    private void scrollUp() {
        this.scrollIndex = Math.max(0, this.scrollIndex - 1);
        this.updateList();
        if (currentCover != null) {
            currentCover.reload();
        }
    }

    public void initLayout() {
        this.widgets.clear();
        this.songDisplay.children.clear();
        this.setDifficulties.children.clear();
        this.difficultyStats.children.clear();
        this.widgets.addAll(List.of(new MenuPanel.ButtonWidget(new Vector3f(-30.0f, -200.0f, 0.05f), new Vector2f(50.0f, 50.0f), this::scrollUp, new MenuPanel.TextureWidget(class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_selector/up_arrow.png"), new Vector3f(), new Vector2f(50.0f, 50.0f)).withScale(0.75f)), new MenuPanel.ButtonWidget(new Vector3f(-30.0f, 200.0f, 0.05f), new Vector2f(50.0f, 50.0f), this::scrollDown, new MenuPanel.TextureWidget(class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_selector/down_arrow.png"), new Vector3f(), new Vector2f(50.0f, 50.0f)).withScale(0.75f)), SettingsMenuPanel.getButton(new MenuPanel.TextWidget("Report bugs", new Vector3f(0.0f, -11.0f, 0.05f), 3.0f).withColor(-4513246), () -> class_407.method_49623(null, (String)"https://github.com/Swifter1243/BeatCraft/issues"), new Vector3f(140.0f, -210.0f, 0.0f), new Vector2f(210.0f, 45.0f)), this.songListContainer, this.songDisplay, this.setDifficulties, this.difficultyStats));
        this.songDisplay.children.add(new MenuPanel.TextureWidget(class_2960.method_60655((String)"beatcraft", (String)"icon.png"), new Vector3f(), new Vector2f(128.0f, 128.0f)).withScale(2.34375f));
        this.updateList();
    }

    public void updateList() {
        int start = this.scrollIndex * 6;
        int end = Math.min(BeatCraftClient.songs.getSongs().size(), start + 6);
        this.songListContainer.children.forEach(c -> {
            if (c instanceof SongDisplayWidget) {
                SongDisplayWidget songDisp = (SongDisplayWidget)c;
                if (songDisp.data != currentDisplay) {
                    songDisp.unloadCover();
                }
            }
        });
        this.songListContainer.children.clear();
        for (int i = start; i < end; ++i) {
            SongData data = BeatCraftClient.songs.getSongs().get(i);
            this.songListContainer.children.add(new SongDisplayWidget(data, new Vector3f(0.0f, (float)((i - start) * 80), 0.05f), this.getPreviewGetter(data)));
        }
    }

    private Runnable getPreviewGetter(SongData data) {
        return () -> this.setPreview(data);
    }

    private static MenuPanel.Widget _getSetDisplayWidget(String set) {
        Vector3f pos = new Vector3f(0.0f, 0.0f, 0.05f);
        return switch (set) {
            case "Standard" -> new MenuPanel.TextureWidget(class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_selector/set_icons/standard.png"), pos, new Vector2f(16.0f, 16.0f)).withScale(1.5625f);
            case "OneSaber" -> new MenuPanel.TextureWidget(class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_selector/set_icons/one_saber.png"), pos, new Vector2f(16.0f, 16.0f)).withScale(1.5625f);
            case "NoArrows" -> new MenuPanel.TextureWidget(class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_selector/set_icons/no_arrows.png"), pos, new Vector2f(16.0f, 16.0f)).withScale(1.5625f);
            case "Lawless" -> new MenuPanel.TextureWidget(class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_selector/set_icons/lawless.png"), pos, new Vector2f(16.0f, 16.0f)).withScale(1.5625f);
            case "360Degree" -> new MenuPanel.TextWidget("360", pos.add(0.0f, -8.0f, 0.0f), 2.0f);
            case "90Degree" -> new MenuPanel.TextWidget("90", pos.add(0.0f, -8.0f, 0.0f), 2.0f);
            default -> new MenuPanel.TextWidget(set, pos.add(0.0f, -8.0f, 0.0f), 1.0f);
        };
    }

    private static MenuPanel.Widget _getDiffDisplayWidget(String diff) {
        Vector3f pos = new Vector3f(0.0f, -8.0f, 0.05f);
        return new MenuPanel.TextWidget(diff, pos, 2.0f);
    }

    private static int getSetSortRank(String set) {
        return switch (set) {
            case "Standard" -> 0;
            case "OneSaber" -> 1;
            case "NoArrows" -> 2;
            case "360Degree" -> 3;
            case "90Degree" -> 4;
            case "Lawless" -> 5;
            default -> 6;
        };
    }

    private MenuPanel.Widget getSetWidget(String set, SongData data, int setIndex, int setCount) {
        int AVAILABLE_WIDTH = 450;
        int widgetWidth = AVAILABLE_WIDTH / setCount;
        int widgetX = 75 + (-(setCount * widgetWidth) / 2 + setIndex * widgetWidth) + widgetWidth / 2;
        MenuPanel.Widget display = SongSelectMenuPanel._getSetDisplayWidget(set);
        return new MenuPanel.ButtonWidget(new Vector3f((float)widgetX, 50.0f, 0.0f), new Vector2f((float)widgetWidth, 40.0f), () -> this.openSet(set, data), new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), List.of(new MenuPanel.DynamicGradientWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), () -> set.equals(selectedSet) ? 0x5F444444 : 0x5F222222, () -> set.equals(selectedSet) ? 0x5F444444 : 0x5F222222, 0.0f)), List.of(new MenuPanel.DynamicGradientWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), () -> set.equals(selectedSet) ? 0x5F888888 : 0x5F666666, () -> set.equals(selectedSet) ? 0x5F888888 : 0x5F666666, 0.0f))), display);
    }

    private MenuPanel.Widget getDiffWidget(String diff, String set, SongData data, int setIndex, int setCount) {
        int AVAILABLE_WIDTH = 450;
        int widgetWidth = AVAILABLE_WIDTH / setCount;
        int widgetX = 75 + (-(setCount * widgetWidth) / 2 + setIndex * widgetWidth) + widgetWidth / 2;
        MenuPanel.Widget display = SongSelectMenuPanel._getDiffDisplayWidget(diff);
        return new MenuPanel.ButtonWidget(new Vector3f((float)widgetX, 100.0f, 0.0f), new Vector2f((float)widgetWidth, 40.0f), () -> this.openDiff(diff, set, data), new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), List.of(new MenuPanel.DynamicGradientWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), () -> diff.equals(selectedDiff) ? 0x5F444444 : 0x5F222222, () -> diff.equals(selectedDiff) ? 0x5F444444 : 0x5F222222, 0.0f)), List.of(new MenuPanel.DynamicGradientWidget(new Vector3f(), new Vector2f((float)widgetWidth, 40.0f), () -> diff.equals(selectedDiff) ? 0x5F888888 : 0x5F666666, () -> diff.equals(selectedDiff) ? 0x5F888888 : 0x5F666666, 0.0f))), display);
    }

    private void openSet(String set, SongData data) {
        List<String> diffs = data.getDifficulties(set);
        selectedSet = set;
        this.setDifficulties.children.clear();
        int i = 0;
        for (String diff : diffs) {
            MenuPanel.Widget diffWidget = this.getDiffWidget(diff, set, data, i, diffs.size());
            this.setDifficulties.children.add(diffWidget);
            ++i;
        }
        if (!diffs.contains(selectedDiff)) {
            selectedDiff = diffs.getLast();
        }
        this.openDiff(selectedDiff, set, data);
    }

    private void openDiff(String diff, String set, SongData data) {
        SongData.BeatmapInfo info = data.getBeatMapInfo(set, diff);
        selectedDiff = diff;
        this.difficultyStats.children.clear();
        this.difficultyStats.children.add(new MenuPanel.ButtonWidget(new Vector3f(150.0f, 200.0f, 0.0f), new Vector2f(130.0f, 50.0f), () -> {
            try {
                this.song_play_request.cancel(true);
                currentDisplay = null;
                HUDRenderer.scene = HUDRenderer.MenuScene.InGame;
                BeatmapPlayer.setupDifficultyFromFile(info.getBeatmapLocation().toString());
                if (BeatCraftClient.playerConfig.doEnvironmentPlacing() && BeatmapPlayer.currentBeatmap.lightShowEnvironment != null) {
                    String env = BeatmapPlayer.currentBeatmap.lightShowEnvironment.getID();
                    ClientPlayNetworking.send((class_8710)new PlaceEnvironmentStructureC2SPayload(env));
                }
                BeatmapAudioPlayer.playAudioFromFile(BeatmapPlayer.currentInfo.getSongFilename());
                BeatmapPlayer.restart();
                GameLogicHandler.reset();
                BeatmapAudioPlayer.muteVanillaMusic();
                if (data.getId() != null) {
                    ClientPlayNetworking.send((class_8710)new MapSyncC2SPayload(data.getId(), set, diff));
                }
                InputSystem.lockHotbar();
            }
            catch (IOException e) {
                BeatCraft.LOGGER.error("There was a tragic failure whilst loading a beatmap", (Throwable)e);
            }
        }, new MenuPanel.HoverWidget(new Vector3f(), new Vector2f(130.0f, 50.0f), List.of(new MenuPanel.GradientWidget(new Vector3f(0.0f, 0.0f, 0.005f), new Vector2f(130.0f, 50.0f), 2133807232, 573395088, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(0.0f, 0.0f, 0.005f), new Vector2f(130.0f, 50.0f), 2135060704, 574779584, 0.0f))), new MenuPanel.TextWidget("PLAY", new Vector3f(0.0f, -11.0f, 0.05f)).withScale(3.0f)));
    }

    private void setPreview(SongData data) {
        class_2960 coverId;
        int height;
        int width;
        this.songDisplay.children.clear();
        currentDisplay = data;
        BeatmapAudioPlayer.beatmapAudio.setPlaybackSpeed(1.0f);
        BeatmapAudioPlayer.playAudioFromFile(data.getPreviewFilename());
        if (this.song_play_request != null) {
            this.song_play_request.cancel(true);
        }
        this.song_play_request = CompletableFuture.runAsync(() -> {
            while (!BeatmapAudioPlayer.isReady()) {
            }
            if (currentDisplay != data || BeatmapPlayer.currentBeatmap != null) {
                return;
            }
            BeatmapAudioPlayer.beatmapAudio.play(data.getPreviewStartTime());
            double start = (double)System.nanoTime() / 1.0E9;
            double fadeTime = 1.2f;
            double fadeStartTime = (double)data.getPreviewDuration() - fadeTime;
            BeatmapAudioPlayer.beatmapAudio.setVolume(BeatCraftClient.playerConfig.getVolume());
            while ((double)System.nanoTime() / 1.0E9 - start < fadeStartTime) {
            }
            if (currentDisplay != data || BeatmapPlayer.currentBeatmap != null) {
                return;
            }
            while ((double)System.nanoTime() / 1.0E9 - start < (double)data.getPreviewDuration()) {
                double elapsed = (double)System.nanoTime() / 1.0E9 - start;
                float fadeProgress = (float)((elapsed - fadeStartTime) / fadeTime);
                float newVolume = BeatCraftClient.playerConfig.getVolume() * (1.0f - fadeProgress);
                BeatmapAudioPlayer.beatmapAudio.setVolume(Math.max(newVolume, 0.0f));
                if (currentDisplay == data && BeatmapPlayer.currentBeatmap == null) continue;
                BeatmapAudioPlayer.beatmapAudio.setVolume(BeatCraftClient.playerConfig.getVolume());
                return;
            }
            BeatmapAudioPlayer.unload();
            BeatmapAudioPlayer.beatmapAudio.setVolume(BeatCraftClient.playerConfig.getVolume());
        });
        try {
            DynamicTexture coverImage = new DynamicTexture(data.getCoverImageFilename());
            width = coverImage.width();
            height = coverImage.height();
            coverId = coverImage.id();
            currentCover = coverImage;
        }
        catch (IOException e) {
            coverId = class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_selector/no_cover.png");
            width = 256;
            height = 256;
        }
        textureId = coverId;
        this.songDisplay.children.addAll(List.of(new MenuPanel.TextureWidget(coverId, new Vector3f(-85.0f, -100.0f, 0.0f), new Vector2f((float)width, (float)height)).withScale(150.0f / (float)width, 150.0f / (float)height), new MenuPanel.TextWidget(data.getTitle(), new Vector3f(0.0f, -175.0f, 0.0f)).withScale(3.0f).alignedLeft().withDynamicScaling(110), new MenuPanel.TextWidget(data.getAuthor(), new Vector3f(0.0f, -145.0f, 0.0f)).withScale(2.5f).alignedLeft().withDynamicScaling(132), new MenuPanel.TextWidget("[" + String.join((CharSequence)", ", data.getMappers()) + "]", new Vector3f(0.0f, -115.0f, 0.0f)).withScale(2.0f).alignedLeft().withColor(-12268510).withDynamicScaling(165), new MenuPanel.ButtonWidget(new Vector3f(30.0f, -35.0f, 0.0f), new Vector2f(60.0f, 25.0f), () -> {
            HUDRenderer.confirmSongDeleteMenuPanel = new ConfirmSongDeleteMenuPanel(new ConfirmSongDeleteMenu(data));
            HUDRenderer.scene = HUDRenderer.MenuScene.ConfirmSongDelete;
        }, new MenuPanel.HoverWidget(new Vector3f(), new Vector2f(60.0f, 25.0f), List.of(new MenuPanel.GradientWidget(new Vector3f(0.0f, 0.0f, 0.0f), new Vector2f(60.0f, 25.0f), 2141851921, 2139623697, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(0.0f, 0.0f, 0.0f), new Vector2f(60.0f, 25.0f), 2144084514, 2141856290, 0.0f))), new MenuPanel.TextWidget("DELETE", new Vector3f(0.0f, -6.0f, 0.05f)).withScale(1.5f))));
        ArrayList<String> sets = new ArrayList<String>(data.getDifficultySets());
        sets.sort(Comparator.comparingInt(SongSelectMenuPanel::getSetSortRank));
        int selectedSetRank = SongSelectMenuPanel.getSetSortRank(selectedSet);
        int selectionDifference = 100;
        String closestSelection = selectedSet;
        int i = 0;
        for (String set : sets) {
            MenuPanel.Widget widget = this.getSetWidget(set, data, i, sets.size());
            int setRank = SongSelectMenuPanel.getSetSortRank(set);
            int df = Math.abs(setRank - selectedSetRank);
            if (df < selectionDifference) {
                selectionDifference = df;
                closestSelection = set;
            }
            this.songDisplay.children.add(widget);
            ++i;
        }
        this.openSet(closestSelection, data);
    }

    @Environment(value=EnvType.CLIENT)
    private static class SongDisplayWidget
    extends MenuPanel.Widget {
        public DynamicTexture coverImage = null;
        protected SongData data;

        protected SongDisplayWidget(SongData songData, Vector3f position, Runnable previewDisplayer) {
            class_2960 coverId;
            int height;
            int width;
            this.data = songData;
            this.position = position;
            try {
                this.coverImage = new DynamicTexture(songData.getCoverImageFilename());
                width = this.coverImage.width();
                height = this.coverImage.height();
                coverId = this.coverImage.id();
            }
            catch (IOException e) {
                coverId = class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_selector/no_cover.png");
                width = 256;
                height = 256;
            }
            this.children.addAll(List.of(new MenuPanel.ButtonWidget(new Vector3f(113.0f, 3.0f, -0.05f), new Vector2f(300.0f, 80.0f), previewDisplayer, new MenuPanel.HoverWidget(new Vector3f(), new Vector2f(300.0f, 80.0f), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f(300.0f, 80.0f), 0x5F222222, 0x5F222222, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f(300.0f, 80.0f), 0x5F444444, 0x5F444444, 0.0f)))), new MenuPanel.TextureWidget(coverId, new Vector3f(), new Vector2f((float)width, (float)height)).withScale(75.0f / (float)width, 75.0f / (float)height), new MenuPanel.TextWidget(songData.getTitle(), new Vector3f(43.0f, -35.0f, 0.0f)).alignedLeft().withScale(2.0f).withDynamicScaling(110), new MenuPanel.TextWidget(songData.getAuthor(), new Vector3f(43.0f, -10.0f, 0.0f)).alignedLeft().withScale(1.5f).withColor(-5592406).withDynamicScaling(146), new MenuPanel.TextWidget("[" + String.join((CharSequence)", ", songData.getMappers()) + "]", new Vector3f(43.0f, 10.0f, 0.0f)).alignedLeft().withScale(1.2f).withColor(-12268510).withDynamicScaling(183)));
        }

        public void unloadCover() {
            if (this.coverImage != null) {
                this.coverImage.unloadTexture();
            }
        }

        @Override
        protected void render(class_332 context, Vector2f pointerPosition) {
            context.translate(-this.position.x, -this.position.y, -this.position.z);
        }
    }
}

