/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.mesh;

import com.beatcraft.render.mesh.Quad;
import com.beatcraft.render.mesh.QuadMesh;
import com.beatcraft.render.mesh.Triangle;
import com.beatcraft.render.mesh.TriangleMesh;
import com.beatcraft.utils.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class MeshSlicer {
    private static final HashMap<Integer, int[][]> flagMap = new HashMap();

    public static class_3545<TriangleMesh, TriangleMesh> sliceMesh(Vector3f planeIncidentPoint, Vector3f planeNormal, QuadMesh mesh) {
        TriangleMesh leftMesh = new TriangleMesh();
        TriangleMesh rightMesh = new TriangleMesh();
        for (Quad quad : mesh.quads) {
            ArrayList<class_3545<Vector3f, Vector2f>> left = new ArrayList<class_3545<Vector3f, Vector2f>>();
            ArrayList<class_3545<Vector3f, Vector2f>> right = new ArrayList<class_3545<Vector3f, Vector2f>>();
            List<class_3545<Vector3f, Vector2f>> vertices = mesh.getQuadVerticesAndUvs(quad);
            for (class_3545<Vector3f, Vector2f> vertex_uv : vertices) {
                if (MeshSlicer.isAbovePlane((Vector3f)vertex_uv.method_15442(), planeIncidentPoint, planeNormal)) {
                    left.add(vertex_uv);
                    right.add(null);
                    continue;
                }
                left.add(null);
                right.add(vertex_uv);
            }
            if (!left.contains(null)) {
                leftMesh.addTris(quad.toTriangles(mesh, leftMesh));
                continue;
            }
            if (!right.contains(null)) {
                rightMesh.addTris(quad.toTriangles(mesh, rightMesh));
                continue;
            }
            List<class_3545<Vector3f, Vector2f>> intersections = MeshSlicer.getIntersections(vertices, planeIncidentPoint, planeNormal);
            List<Triangle> leftTris = MeshSlicer.reconstruct(leftMesh.vertices, left, intersections);
            List<Triangle> rightTris = MeshSlicer.reconstruct(rightMesh.vertices, right, intersections);
            leftMesh.tris.addAll(leftTris);
            rightMesh.tris.addAll(rightTris);
        }
        return new class_3545((Object)leftMesh, (Object)rightMesh);
    }

    private static int getNull(List<class_3545<Vector3f, Vector2f>> ls) {
        return (ls.getFirst() != null ? 8 : 0) + (ls.get(1) != null ? 4 : 0) + (ls.get(2) != null ? 2 : 0) + (ls.get(3) != null ? 1 : 0);
    }

    private static List<Triangle> reconstruct(ArrayList<Vector3f> vertices, List<class_3545<Vector3f, Vector2f>> square, List<class_3545<Vector3f, Vector2f>> intersects) {
        int sFlag = MeshSlicer.getNull(square);
        int iFlag = MeshSlicer.getNull(intersects);
        ArrayList<class_3545<Vector3f, Vector2f>> combined = new ArrayList<class_3545<Vector3f, Vector2f>>(square);
        combined.addAll(intersects);
        int[][] indices = flagMap.get(sFlag << 4 | iFlag);
        if (indices == null) {
            return List.of();
        }
        ArrayList<List<class_3545<Vector3f, Vector2f>>> out = new ArrayList<List<class_3545<Vector3f, Vector2f>>>();
        for (int[] tri : indices) {
            out.add(List.of((class_3545)combined.get(tri[0]), (class_3545)combined.get(tri[1]), (class_3545)combined.get(tri[2])));
        }
        return Triangle.fromList(vertices, out);
    }

    private static boolean isAbovePlane(Vector3f point, Vector3f planePoint, Vector3f planeNormal) {
        return planeNormal.dot((Vector3fc)new Vector3f((Vector3fc)point).sub((Vector3fc)planePoint)) > 0.0f;
    }

    private static List<class_3545<Vector3f, Vector2f>> getIntersections(List<class_3545<Vector3f, Vector2f>> quad, Vector3f planePoint, Vector3f planeNormal) {
        ArrayList<class_3545<Vector3f, Vector2f>> intersections = new ArrayList<class_3545<Vector3f, Vector2f>>();
        for (int i = 0; i < quad.size(); ++i) {
            class_3545<Vector3f, Vector2f> v1 = quad.get(i);
            class_3545<Vector3f, Vector2f> v2 = quad.get((i + 1) % quad.size());
            if (MeshSlicer.isAbovePlane((Vector3f)v1.method_15442(), planePoint, planeNormal) != MeshSlicer.isAbovePlane((Vector3f)v2.method_15442(), planePoint, planeNormal)) {
                intersections.add(MeshSlicer.getIntersect(v1, v2, planePoint, planeNormal));
                continue;
            }
            intersections.add(null);
        }
        return intersections;
    }

    private static class_3545<Vector3f, Vector2f> getIntersect(class_3545<Vector3f, Vector2f> v1, class_3545<Vector3f, Vector2f> v2, Vector3f planePoint, Vector3f planeNormal) {
        Vector3f edge = new Vector3f((Vector3fc)v2.method_15442()).sub((Vector3fc)v1.method_15442());
        float t = planeNormal.dot((Vector3fc)new Vector3f((Vector3fc)planePoint).sub((Vector3fc)v1.method_15442())) / planeNormal.dot((Vector3fc)edge);
        Vector3f pos = new Vector3f((Vector3fc)v1.method_15442()).add((Vector3fc)edge.mul(t));
        float f = MathUtil.inverseLerpVector3((Vector3f)v1.method_15442(), (Vector3f)v2.method_15442(), pos);
        Vector2f uv = MathUtil.lerpVector2((Vector2f)v1.method_15441(), (Vector2f)v2.method_15441(), f);
        return new class_3545((Object)pos, (Object)uv);
    }

    static {
        flagMap.put(154, new int[][]{{0, 4, 6}, {6, 0, 3}});
        flagMap.put(197, new int[][]{{0, 1, 5}, {5, 0, 7}});
        flagMap.put(106, new int[][]{{4, 1, 2}, {2, 4, 6}});
        flagMap.put(53, new int[][]{{7, 5, 2}, {2, 7, 3}});
        flagMap.put(76, new int[][]{{1, 4, 5}});
        flagMap.put(38, new int[][]{{2, 5, 6}});
        flagMap.put(19, new int[][]{{3, 6, 7}});
        flagMap.put(137, new int[][]{{0, 7, 4}});
        flagMap.put(227, new int[][]{{0, 2, 6}, {0, 1, 2}, {6, 0, 7}});
        flagMap.put(121, new int[][]{{1, 3, 7}, {1, 2, 3}, {7, 1, 4}});
        flagMap.put(188, new int[][]{{0, 2, 5}, {2, 3, 0}, {5, 0, 4}});
        flagMap.put(214, new int[][]{{1, 3, 6}, {3, 0, 1}, {6, 1, 5}});
    }
}

