/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.mesh;

import com.beatcraft.render.mesh.Mesh;
import com.beatcraft.render.mesh.Quad;
import com.beatcraft.render.mesh.TriangleMesh;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class QuadMesh
implements Mesh {
    public ArrayList<Vector3f> vertices;
    public ArrayList<Quad> quads;
    public class_2960 texture;
    public int color;

    public QuadMesh(List<Vector3f> vertices, List<Quad> quads) {
        this.vertices = new ArrayList<Vector3f>(vertices);
        this.quads = new ArrayList<Quad>(quads);
        this.color = -1;
    }

    public QuadMesh() {
        this.vertices = new ArrayList();
        this.quads = new ArrayList();
        this.color = -1;
    }

    public TriangleMesh toTriangleMesh() {
        TriangleMesh newMesh = new TriangleMesh();
        for (Quad quad : this.quads) {
            newMesh.addTris(quad.toTriangles(this, newMesh));
        }
        newMesh.texture = this.texture;
        newMesh.color = this.color;
        return newMesh;
    }

    public List<class_3545<Vector3f, Vector2f>> getQuadVerticesAndUvs(Quad quad) {
        return List.of(new class_3545((Object)this.vertices.get(quad.a()), (Object)quad.uvA()), new class_3545((Object)this.vertices.get(quad.b()), (Object)quad.uvB()), new class_3545((Object)this.vertices.get(quad.c()), (Object)quad.uvC()), new class_3545((Object)this.vertices.get(quad.d()), (Object)quad.uvD()));
    }

    public int vertIdx(Vector3f vec) {
        return this.vertices.indexOf(vec);
    }

    public void addPermutedVertices(Vector3f min, Vector3f max) {
        this.addIfNotPresent(new Vector3f(min.x, min.y, min.z));
        this.addIfNotPresent(new Vector3f(min.x, min.y, max.z));
        this.addIfNotPresent(new Vector3f(min.x, max.y, min.z));
        this.addIfNotPresent(new Vector3f(min.x, max.y, max.z));
        this.addIfNotPresent(new Vector3f(max.x, min.y, min.z));
        this.addIfNotPresent(new Vector3f(max.x, min.y, max.z));
        this.addIfNotPresent(new Vector3f(max.x, max.y, min.z));
        this.addIfNotPresent(new Vector3f(max.x, max.y, max.z));
    }

    public void addUniquePermutedVertices(Vector3f min, Vector3f max) {
        this.addUnique(new Vector3f(min.x, min.y, min.z));
        this.addUnique(new Vector3f(min.x, min.y, max.z));
        this.addUnique(new Vector3f(min.x, max.y, min.z));
        this.addUnique(new Vector3f(min.x, max.y, max.z));
        this.addUnique(new Vector3f(max.x, min.y, min.z));
        this.addUnique(new Vector3f(max.x, min.y, max.z));
        this.addUnique(new Vector3f(max.x, max.y, min.z));
        this.addUnique(new Vector3f(max.x, max.y, max.z));
    }

    public void addIfNotPresent(Vector3f vec) {
        if (!this.vertices.contains(vec)) {
            this.vertices.add(vec);
        }
    }

    public void addUnique(Vector3f vec) {
        this.vertices.add(vec);
    }

    public void transformVertices(int start, int end, Consumer<Vector3f> transformer) {
        for (Vector3f vert : this.vertices.subList(start, end)) {
            transformer.accept(vert);
        }
    }

    @Override
    public void drawToBuffer(class_287 buffer, Vector3f position, Quaternionf orientation, Vector3f cameraPos) {
        this.quads.forEach(quad -> quad.draw(buffer, this.color, this, position, orientation, cameraPos));
    }
}

