/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.object;

import com.beatcraft.animation.AnimationState;
import com.beatcraft.beatmap.data.object.BombNote;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.MirrorHandler;
import com.beatcraft.render.mesh.MeshLoader;
import com.beatcraft.render.object.PhysicalGameplayObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1091;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.apache.logging.log4j.util.BiConsumer;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class PhysicalBombNote
extends PhysicalGameplayObject<BombNote> {
    public static final class_1091 bombNoteArrowModelID = new class_1091(class_2960.method_60655((String)"beatcraft", (String)"bomb_note"), "inventory");
    private static final int overlay = class_4608.method_23624((float)0.0f, (boolean)false);
    private static final Hitbox DOT_GOOD_CUT_BOUNDS = new Hitbox(new Vector3f(-0.4f, -0.4f, -0.75f), new Vector3f(0.4f, 0.4f, 0.25f));
    private static final Hitbox BAD_CUT_BOUNDS = new Hitbox(new Vector3f(-0.175f, -0.175f, -0.175f), new Vector3f(0.175f, 0.175f, 0.175f));

    public PhysicalBombNote(BombNote data) {
        super(data);
    }

    @Override
    protected void objectRender(class_4587 matrices, class_4588 vertexConsumer, AnimationState animationState) {
        class_4587.class_4665 localPos = matrices.method_23760();
        Vector3f renderPos = localPos.method_23761().getTranslation(new Vector3f()).add((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
        Quaternionf renderRotation = localPos.method_23761().getUnnormalizedRotation(new Quaternionf());
        BeatCraftRenderer.recordNoteRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(tri, cam) -> {
            MeshLoader.BOMB_RENDER_MESH.color = ((BombNote)this.data).getColor().toARGB();
            MeshLoader.BOMB_RENDER_MESH.drawToBuffer((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
        }));
        MirrorHandler.recordMirrorNoteDraw((tri, cam) -> {
            MeshLoader.BOMB_RENDER_MESH.color = ((BombNote)this.data).getColor().toARGB();
            MeshLoader.BOMB_RENDER_MESH.drawToBufferMirrored((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
        });
    }

    @Override
    public float getCollisionDistance() {
        return 0.607f;
    }

    @Override
    public Hitbox getBadCutBounds() {
        return BAD_CUT_BOUNDS;
    }

    @Override
    public Hitbox getGoodCutBounds() {
        return DOT_GOOD_CUT_BOUNDS;
    }
}

