/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.object;

import com.beatcraft.animation.AnimationState;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.beatmap.data.object.ChainNoteHead;
import com.beatcraft.beatmap.data.object.ScorableObject;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.MirrorHandler;
import com.beatcraft.render.mesh.MeshLoader;
import com.beatcraft.render.mesh.QuadMesh;
import com.beatcraft.render.object.PhysicalColorNote;
import com.beatcraft.render.object.PhysicalGameplayObject;
import com.beatcraft.render.object.PhysicalScorableObject;
import com.beatcraft.utils.NoteMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class PhysicalChainNoteHead
extends PhysicalGameplayObject<ChainNoteHead>
implements PhysicalScorableObject {
    public static final class_1091 chainHeadModelID = new class_1091(class_2960.method_60655((String)"beatcraft", (String)"color_note_chain_head"), "inventory");
    private static final int overlay = class_4608.method_23624((float)0.0f, (boolean)false);
    private float baseDegrees;
    public static final Hitbox ACCURATE_HITBOX = new Hitbox(new Vector3f(-0.25f, 0.0f, -0.25f), new Vector3f(0.25f, 0.25f, 0.25f));

    public PhysicalChainNoteHead(ChainNoteHead data) {
        super(data);
        this.cutResult = GameLogicHandler.CutResult.noHit(this);
        this.baseDegrees = NoteMath.degreesFromCut(data.getCutDirection());
        this.baseDegrees = (this.baseDegrees + data.getAngleOffset()) % 360.0f;
    }

    public Vector3f worldToCameraSpace(Vector3f renderPos, Vector3f cameraPos, Quaternionf cameraRot) {
        Vector3f a = renderPos.sub((Vector3fc)cameraPos, new Vector3f());
        a.rotate((Quaternionfc)cameraRot);
        a.add((Vector3fc)cameraPos);
        return a;
    }

    @Override
    protected void objectRender(class_4587 matrices, class_4588 vertexConsumer, AnimationState animationState) {
        Quaternionf renderRotation;
        Vector3f renderPos;
        class_4587.class_4665 localPos = matrices.method_23760();
        class_1087 arrowModel = mc.method_1554().method_4742(PhysicalColorNote.noteArrowModelID);
        if (!this.isBaseDissolved()) {
            renderPos = localPos.method_23761().getTranslation(new Vector3f()).add((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
            renderRotation = localPos.method_23761().getUnnormalizedRotation(new Quaternionf());
            BeatCraftRenderer.recordNoteRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(tri, cam) -> {
                MeshLoader.CHAIN_HEAD_RENDER_MESH.color = ((ChainNoteHead)this.data).getColor().toARGB();
                MeshLoader.CHAIN_HEAD_RENDER_MESH.drawToBuffer((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
            }));
            MirrorHandler.recordMirrorNoteDraw((tri, cam) -> {
                MeshLoader.CHAIN_HEAD_RENDER_MESH.color = ((ChainNoteHead)this.data).getColor().toARGB();
                MeshLoader.CHAIN_HEAD_RENDER_MESH.drawToBufferMirrored((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
            });
        }
        if (!this.isArrowDissolved()) {
            renderPos = localPos.method_23761().getTranslation(new Vector3f()).add((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
            renderRotation = localPos.method_23761().getUnnormalizedRotation(new Quaternionf());
            BeatCraftRenderer.recordArrowRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(tri, cam) -> {
                MeshLoader.NOTE_ARROW_RENDER_MESH.color = -1;
                MeshLoader.NOTE_ARROW_RENDER_MESH.drawToBuffer((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
            }));
            MirrorHandler.recordMirrorArrowDraw((tri, cam) -> {
                MeshLoader.NOTE_ARROW_RENDER_MESH.color = -1;
                MeshLoader.NOTE_ARROW_RENDER_MESH.drawToBufferMirrored((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
            });
            BeatCraftRenderer.bloomfog.recordArrowBloomCall((TriConsumer<class_287, Vector3f, Quaternionf>)((TriConsumer)(b, v, q) -> {
                MeshLoader.NOTE_ARROW_RENDER_MESH.color = ((ChainNoteHead)this.data).getColor().toARGB();
                MeshLoader.NOTE_ARROW_RENDER_MESH.drawToBuffer((class_287)b, this.worldToCameraSpace(renderPos, (Vector3f)v, (Quaternionf)q), q.mul((Quaternionfc)renderRotation, new Quaternionf()), (Vector3f)v);
            }));
        }
    }

    @Override
    protected boolean doNoteLook() {
        return !((ChainNoteHead)this.data).isNoteLookDisabled();
    }

    @Override
    protected boolean doNoteGravity() {
        return !((ChainNoteHead)this.data).isNoteGravityDisabled();
    }

    public void finalizeBaseRotation() {
        float radians = Math.toRadians((float)this.baseDegrees);
        this.baseRotation = new Quaternionf().rotateZ(radians);
    }

    @Override
    public float getCollisionDistance() {
        return 0.688f;
    }

    @Override
    public Hitbox getGoodCutBounds() {
        return PhysicalColorNote.NORMAL_GOOD_CUT_BOUNDS;
    }

    @Override
    public Hitbox getBadCutBounds() {
        return PhysicalColorNote.BAD_CUT_BOUNDS;
    }

    @Override
    public Hitbox getAccurateHitbox() {
        return ACCURATE_HITBOX;
    }

    @Override
    public ScorableObject score$getData() {
        return (ScorableObject)this.getData();
    }

    @Override
    public void score$setContactColor(NoteType type) {
        this.setContactColor(type);
    }

    @Override
    public void score$setCutResult(GameLogicHandler.CutResult cut) {
        this.setCutResult(cut);
    }

    @Override
    public void score$cutNote() {
        this.cutNote();
    }

    @Override
    public GameLogicHandler.CutResult score$getCutResult() {
        return this.getCutResult();
    }

    @Override
    public int score$getMaxCutPositionScore() {
        return 15;
    }

    @Override
    public int score$getMaxFollowThroughScore() {
        return 30;
    }

    @Override
    public int score$getMaxFollowThroughAngle() {
        return 60;
    }

    @Override
    public int score$getMaxSwingInScore() {
        return 70;
    }

    @Override
    public int score$getMaxSwingInAngle() {
        return 100;
    }

    @Override
    public Quaternionf score$getLaneRotation() {
        return this.getLaneRotation();
    }

    @Override
    public QuadMesh getMesh() {
        return MeshLoader.CHAIN_HEAD_MESH;
    }
}

