/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.object;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.animation.AnimationState;
import com.beatcraft.animation.Easing;
import com.beatcraft.audio.BeatmapAudioPlayer;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.beatmap.data.object.BeatmapObject;
import com.beatcraft.beatmap.data.object.GameplayObject;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.render.SpawnQuaternionPool;
import com.beatcraft.render.WorldRenderer;
import com.beatcraft.render.mesh.MeshLoader;
import com.beatcraft.render.mesh.MeshSlicer;
import com.beatcraft.render.mesh.QuadMesh;
import com.beatcraft.render.mesh.TriangleMesh;
import com.beatcraft.render.object.PhysicalScorableObject;
import com.beatcraft.render.particle.BeatcraftParticleRenderer;
import com.beatcraft.render.particle.Debris;
import com.beatcraft.utils.MathUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public abstract class PhysicalGameplayObject<T extends GameplayObject>
extends WorldRenderer {
    private static final float JUMP_FAR_Z = 500.0f;
    private static final float JUMP_SECONDS = 0.4f;
    protected static final float SIZE_SCALAR = 0.5f;
    protected static final Vector3f WORLD_OFFSET = new Vector3f(0.0f, 0.8f, 1.0f);
    protected final Quaternionf spawnQuaternion = SpawnQuaternionPool.getRandomQuaternion();
    protected Quaternionf baseRotation = new Quaternionf();
    private Quaternionf laneRotation = new Quaternionf();
    private Quaternionf lookRotation = new Quaternionf();
    private Vector3f worldPos = new Vector3f();
    private Quaternionf worldRot = new Quaternionf();
    private Matrix4f matrix = new Matrix4f();
    private AnimationState animationState = new AnimationState();
    protected T data;
    protected boolean despawned = false;
    protected GameLogicHandler.CutResult cutResult = GameLogicHandler.CutResult.noHit(null);
    private NoteType contactColor = null;

    public PhysicalGameplayObject(T data) {
        this.data = data;
    }

    private Vector3f getPlayerHeadPosition() {
        return new Vector3f(0.0f, 1.62f, 0.0f);
    }

    public float getSpawnBeat() {
        return ((BeatmapObject)this.getData()).getBeat() - ((GameplayObject)this.data).getJumps().halfDuration();
    }

    public float getJumpOutBeat() {
        return ((BeatmapObject)this.getData()).getBeat() + ((GameplayObject)this.data).getJumps().halfDuration() * 0.5f;
    }

    public float getDespawnBeat() {
        return ((BeatmapObject)this.getData()).getBeat() + ((GameplayObject)this.data).getJumps().halfDuration();
    }

    public float getSpawnPosition() {
        return ((GameplayObject)this.data).getJumps().jumpDistance() / 2.0f;
    }

    public float getJumpOutPosition() {
        return ((GameplayObject)this.data).getJumps().jumpDistance() * -0.25f;
    }

    private void despawn() {
        this.despawned = true;
    }

    public boolean isDespawned() {
        return this.despawned;
    }

    public void seek(float beat) {
        this.despawned = false;
        PhysicalGameplayObject physicalGameplayObject = this;
        if (physicalGameplayObject instanceof PhysicalScorableObject) {
            PhysicalScorableObject scorable = (PhysicalScorableObject)((Object)physicalGameplayObject);
            this.cutResult = GameLogicHandler.CutResult.noHit(scorable);
        }
        this.update(beat);
    }

    public void update(float beat) {
        PhysicalGameplayObject physicalGameplayObject;
        if (!this.isInWorld()) {
            return;
        }
        AnimationState animatedPropertyState = ((GameplayObject)this.data).getTrackContainer().getAnimatedPropertyState();
        if (this.jumpEnded(beat = this.applyTimeRemapping(beat, animatedPropertyState))) {
            this.despawn();
            return;
        }
        if (this.pastBeat(beat) && (physicalGameplayObject = this) instanceof PhysicalScorableObject) {
            PhysicalScorableObject scorable = (PhysicalScorableObject)((Object)physicalGameplayObject);
            scorable.score$getCutResult().setContactPosition(this.getWorldPos());
            scorable.score$getCutResult().finalizeScore();
        }
        float lifetime = this.getLifetime(beat);
        this.animationState = animatedPropertyState;
        this.animationState = AnimationState.combine(this.animationState, this.getObjectPathAnimationState(lifetime));
        this.animationState = AnimationState.combine(this.animationState, this.getTrackPathAnimationState(lifetime));
        this.matrix = this.getMatrix(beat, this.animationState);
    }

    public boolean hasAppeared() {
        if (BeatmapPlayer.currentBeatmap == null) {
            return false;
        }
        float margin = BeatmapPlayer.currentInfo.getBeat(0.4f, 1.0f);
        return BeatmapPlayer.getCurrentBeat() >= this.getSpawnBeat() - margin;
    }

    public boolean isInWorld() {
        return this.hasAppeared() && !this.isDespawned() && BeatmapAudioPlayer.isReady();
    }

    protected boolean isBaseDissolved() {
        Float dissolve = (Float)this.animationState.getDissolve();
        if (dissolve == null) {
            return false;
        }
        return (double)dissolve.floatValue() < 0.5;
    }

    protected boolean isArrowDissolved() {
        Float dissolveArrow = (Float)this.animationState.getDissolveArrow();
        if (dissolveArrow == null) {
            return false;
        }
        return (double)dissolveArrow.floatValue() < 0.5;
    }

    @Override
    public boolean shouldRender() {
        return this.isInWorld();
    }

    protected Vector3f getJumpsPosition(float lifetime, float time) {
        Vector2f xy = this.getJumpsXY(lifetime);
        return new Vector3f(xy.x, xy.y, this.getJumpsZ(time));
    }

    protected Vector2f getJumpsXY(float lifetime) {
        float reverseSpawnTime = 1.0f - Math.abs((float)(lifetime - 0.5f)) * 2.0f;
        float jumpTime = Easing.easeOutQuad(reverseSpawnTime);
        Vector2f grid = this.get2DPosition();
        grid.y = Math.lerp((float)(this.doNoteGravity() ? -0.3f : grid.y - 0.3f), (float)grid.y, (float)jumpTime);
        return grid;
    }

    protected float getJumpsZ(float time) {
        float spawnPosition = this.getSpawnPosition();
        float jumpOutPosition = this.getJumpOutPosition();
        float spawnBeat = this.getSpawnBeat();
        float jumpOutBeat = this.getJumpOutBeat();
        if (time < spawnBeat) {
            float percent = (spawnBeat - time) / 2.0f;
            return Math.lerp((float)spawnPosition, (float)500.0f, (float)percent);
        }
        if (time < jumpOutBeat) {
            float percent = MathUtil.inverseLerp(spawnBeat, jumpOutBeat, time);
            return Math.lerp((float)spawnPosition, (float)jumpOutPosition, (float)percent);
        }
        float percent = MathUtil.inverseLerp(jumpOutBeat, this.getDespawnBeat(), time);
        percent *= percent;
        return Math.lerp((float)jumpOutPosition, (float)-500.0f, (float)percent);
    }

    protected Vector2f get2DPosition() {
        float x = (((GameplayObject)this.getData()).getX() - 1.5f) * 0.6f;
        float y = ((GameplayObject)this.getData()).getY() * 0.6f;
        return new Vector2f(x, y);
    }

    protected float getLifetime(float beat) {
        float lifetime = MathUtil.inverseLerp(this.getSpawnBeat(), this.getDespawnBeat(), beat);
        return MathUtil.clamp01(lifetime);
    }

    protected float getSpawnLifetime(float lifetime) {
        return MathUtil.clamp01(lifetime * 2.0f);
    }

    protected Matrix4f getMatrix(float time, AnimationState animationState) {
        Matrix4f m = new Matrix4f();
        Matrix4f parentMatrix = ((GameplayObject)this.data).getTrackContainer().tryGetParentMatrix();
        if (parentMatrix != null) {
            m.mul((Matrix4fc)parentMatrix);
        }
        m.translate(this.getPlayerHeadPosition().x, 0.0f, this.getPlayerHeadPosition().z);
        if (((GameplayObject)this.data).getWorldRotation() != null) {
            m.rotate((Quaternionfc)((GameplayObject)this.data).getWorldRotation());
        }
        if (animationState.getOffsetWorldRotation() != null) {
            m.rotate((Quaternionfc)animationState.getOffsetWorldRotation());
        }
        if (animationState.getOffsetPosition() != null) {
            m.translate((Vector3fc)animationState.getOffsetPosition());
        }
        if (this.getLaneRotation() != null) {
            m.rotate((Quaternionfc)this.getLaneRotation());
        }
        this.applySpawnMatrix(time, m, animationState);
        MathUtil.reflectMatrixAcrossX(m);
        return m;
    }

    protected boolean doNoteLook() {
        return false;
    }

    protected boolean doNoteGravity() {
        return true;
    }

    protected void applySpawnMatrix(float time, Matrix4f m, AnimationState animationState) {
        float lifetime = this.getLifetime(time);
        float spawnLifetime = this.getSpawnLifetime(lifetime);
        Matrix4f jumpMatrix = new Matrix4f();
        Vector3f v = this.getJumpsPosition(lifetime, time);
        jumpMatrix.translate((Vector3fc)v);
        m.translate((Vector3fc)WORLD_OFFSET);
        if (this.doNoteLook()) {
            if ((double)lifetime < 0.5) {
                Vector3f headPosition = this.getPlayerHeadPosition();
                headPosition = MathUtil.matrixTransformPoint3D(new Matrix4f((Matrix4fc)m).invert(), headPosition);
                headPosition = MathUtil.matrixTransformPoint3D(jumpMatrix, headPosition.mul(-1.0f));
                Vector3f up = new Vector3f(0.0f, 0.0f, 1.0f);
                Quaternionf targetLookRotation = new Quaternionf().rotateTo((Vector3fc)up, (Vector3fc)headPosition);
                this.lookRotation = new Quaternionf().slerp((Quaternionfc)targetLookRotation, spawnLifetime);
            }
            m.mul((Matrix4fc)jumpMatrix).rotate((Quaternionfc)this.lookRotation);
        } else {
            m.mul((Matrix4fc)jumpMatrix);
        }
        Vector3f animatedScale = (Vector3f)animationState.getScale();
        if (animatedScale != null) {
            m.scale((Vector3fc)animatedScale);
        }
        if (((GameplayObject)this.data).getLocalRotation() != null) {
            m.rotate((Quaternionfc)((GameplayObject)this.data).getLocalRotation());
        }
        if (animationState.getLocalRotation() != null) {
            m.rotate((Quaternionfc)animationState.getLocalRotation());
        }
        if ((double)lifetime < 0.5) {
            m.rotate((Quaternionfc)this.getJumpsRotation(spawnLifetime));
        } else {
            m.rotate((Quaternionfc)this.baseRotation);
        }
    }

    protected Quaternionf getJumpsRotation(float spawnLifetime) {
        float rotationLifetime = MathUtil.clamp01(spawnLifetime / 0.3f);
        if (spawnLifetime == 0.0f) {
            return this.baseRotation;
        }
        float rotationTime = Easing.easeOutQuad(rotationLifetime);
        return new Quaternionf().set((Quaternionfc)this.spawnQuaternion).slerp((Quaternionfc)this.baseRotation, rotationTime);
    }

    protected boolean jumpEnded(float beat) {
        return beat >= this.getDespawnBeat();
    }

    protected boolean pastBeat(float beat) {
        return beat > ((BeatmapObject)this.getData()).getBeat() + 0.25f;
    }

    private void applyMatrixToRender(Matrix4f matrix, class_4587 matrices) {
        Matrix3f normalMatrix = new Matrix3f();
        matrix.get3x3(normalMatrix);
        matrices.method_34425(matrix);
        matrices.method_23760().method_23762().mul((Matrix3fc)normalMatrix);
    }

    private float applyTimeRemapping(float beat, AnimationState animatedPropertyState) {
        float spawnBeat = this.getSpawnBeat();
        float despawnBeat = this.getDespawnBeat();
        Float animationTime = (Float)animatedPropertyState.getTime();
        if (beat >= spawnBeat && animationTime != null) {
            return Math.lerp((float)spawnBeat, (float)despawnBeat, (float)animationTime.floatValue());
        }
        return beat;
    }

    private AnimationState getObjectPathAnimationState(float lifetime) {
        return ((GameplayObject)this.data).getPathAnimation().toState(lifetime);
    }

    private AnimationState getTrackPathAnimationState(float lifetime) {
        return ((GameplayObject)this.data).getTrackContainer().getAnimatedPathState(lifetime);
    }

    @Override
    protected void worldRender(class_4587 matrices, class_4588 vertexConsumer) {
        this.applyMatrixToRender(this.matrix, matrices);
        this.worldPos = matrices.method_23760().method_23761().getTranslation(this.worldPos).add((Vector3fc)PhysicalGameplayObject.mc.field_1773.method_19418().method_19326().method_46409());
        this.worldRot = matrices.method_23760().method_23761().getUnnormalizedRotation(this.worldRot);
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        matrices.method_22904(-0.5, -0.5, -0.5);
        GameLogicHandler.checkNote(this);
        this.objectRender(matrices, vertexConsumer, this.animationState);
    }

    protected abstract void objectRender(class_4587 var1, class_4588 var2, AnimationState var3);

    public T getData() {
        return this.data;
    }

    public Quaternionf getLaneRotation() {
        return this.laneRotation;
    }

    public void setLaneRotation(Quaternionf laneRotation) {
        this.laneRotation = laneRotation;
    }

    public float getCollisionDistance() {
        return 0.0f;
    }

    public Vector3f getWorldPos() {
        return this.worldPos;
    }

    public Quaternionf getWorldRot() {
        return this.worldRot;
    }

    public Hitbox getGoodCutBounds() {
        return new Hitbox(new Vector3f(), new Vector3f());
    }

    public Hitbox getBadCutBounds() {
        return new Hitbox(new Vector3f(), new Vector3f());
    }

    public Hitbox getAccurateHitbox() {
        return new Hitbox(new Vector3f(), new Vector3f());
    }

    public void cutNote() {
        this.despawn();
    }

    public GameLogicHandler.CutResult getCutResult() {
        return this.cutResult;
    }

    public void setCutResult(GameLogicHandler.CutResult cutResult) {
        this.cutResult = cutResult;
    }

    @Nullable
    public NoteType getContactColor() {
        return this.contactColor;
    }

    public void setContactColor(NoteType color) {
        this.contactColor = color;
    }

    public QuadMesh getMesh() {
        return null;
    }

    public void spawnDebris(Vector3f notePos, Quaternionf noteOrientation, NoteType color, Vector3f planeIncident, Vector3f planeNormal) {
        if (BeatCraftClient.playerConfig.isReducedDebris() || BeatmapPlayer.currentBeatmap == null) {
            return;
        }
        QuadMesh mesh = this.getMesh();
        if (mesh == null) {
            return;
        }
        class_3545<TriangleMesh, TriangleMesh> meshes = MeshSlicer.sliceMesh(planeIncident, planeNormal, mesh);
        if (color == NoteType.RED) {
            ((TriangleMesh)meshes.method_15442()).color = BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB();
            ((TriangleMesh)meshes.method_15441()).color = BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB();
        } else {
            ((TriangleMesh)meshes.method_15442()).color = BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB();
            ((TriangleMesh)meshes.method_15441()).color = BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB();
        }
        ((TriangleMesh)meshes.method_15442()).texture = MeshLoader.NOTE_TEXTURE;
        ((TriangleMesh)meshes.method_15441()).texture = MeshLoader.NOTE_TEXTURE;
        float velocity = -BeatmapPlayer.currentBeatmap.getSetDifficulty().getNjs();
        Debris left = new Debris(new Vector3f((Vector3fc)notePos), new Quaternionf((Quaternionfc)noteOrientation), new Vector3f(0.0f, 0.0f, velocity).add((Vector3fc)planeNormal.mul(2.0f, new Vector3f())).rotate((Quaternionfc)this.laneRotation.invert(new Quaternionf())), new Quaternionf().rotateY(-0.02f).rotateX(-0.03f), (TriangleMesh)meshes.method_15442());
        Debris right = new Debris(new Vector3f((Vector3fc)notePos), new Quaternionf((Quaternionfc)noteOrientation), new Vector3f(0.0f, 0.0f, velocity).add((Vector3fc)planeNormal.mul(-2.0f, new Vector3f())).rotate((Quaternionfc)this.laneRotation.invert(new Quaternionf())), new Quaternionf().rotateY(0.02f).rotateX(-0.03f), (TriangleMesh)meshes.method_15441());
        BeatcraftParticleRenderer.addParticle(left);
        BeatcraftParticleRenderer.addParticle(right);
    }
}

