/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.object;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.animation.AnimationState;
import com.beatcraft.animation.Easing;
import com.beatcraft.beatmap.data.object.Obstacle;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.MirrorHandler;
import com.beatcraft.render.effect.ObstacleGlowRenderer;
import com.beatcraft.render.object.PhysicalGameplayObject;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class PhysicalObstacle
extends PhysicalGameplayObject<Obstacle> {
    private final Hitbox bounds = new Hitbox(new Vector3f(-0.3f, 0.0f, 0.0f), new Vector3f(0.3f, 0.0f, 0.0f));

    public PhysicalObstacle(Obstacle data) {
        super(data);
    }

    @Override
    protected Quaternionf getJumpsRotation(float spawnLifetime) {
        return new Quaternionf();
    }

    @Override
    protected void objectRender(class_4587 matrices, class_4588 vertexConsumer, AnimationState animationState) {
        Vector3f localPos = matrices.method_23760().method_23761().getTranslation(MemoryPool.newVector3f());
        Quaternionf rotation = matrices.method_23760().method_23761().getUnnormalizedRotation(MemoryPool.newQuaternionf());
        this.updateBounds();
        Vector3f camPos = MemoryPool.newVector3f(PhysicalObstacle.mc.field_1773.method_19418().method_19326());
        localPos.add((Vector3fc)camPos);
        MemoryPool.release(camPos);
        GameLogicHandler.checkObstacle(this, localPos, rotation);
        this.render(MemoryPool.newVector3f(localPos), MemoryPool.newQuaternionf(rotation));
        this.renderMirrored(MemoryPool.newVector3f(localPos), MemoryPool.newQuaternionf(rotation));
        int color = BeatmapPlayer.currentBeatmap.getSetDifficulty().getColorScheme().getObstacleColor().toARGB();
        ObstacleGlowRenderer.render(MemoryPool.newVector3f(localPos), MemoryPool.newQuaternionf(rotation), this.bounds, color);
        ObstacleGlowRenderer.renderMirrored(localPos, rotation, this.bounds, color);
    }

    @Override
    protected boolean doNoteLook() {
        return false;
    }

    @Override
    protected boolean doNoteGravity() {
        return false;
    }

    private void render(Vector3f pos, Quaternionf orientation) {
        BeatCraftRenderer.recordObstacleRenderCall((TriConsumer<class_287, Vector3f, Integer>)((TriConsumer)(b, c, i) -> this._render((class_287)b, (Vector3f)c, (int)i, pos, orientation, false)));
    }

    private void renderMirrored(Vector3f pos, Quaternionf orientation) {
        Vector3f flippedPos = pos.mul(1.0f, -1.0f, 1.0f);
        Quaternionf flippedRot = MemoryPool.newQuaternionf(-orientation.x, orientation.y, -orientation.z, orientation.w);
        MemoryPool.release(orientation);
        MirrorHandler.recordMirroredObstacleRenderCall((TriConsumer<class_287, Vector3f, Integer>)((TriConsumer)(b, c, i) -> this._render((class_287)b, (Vector3f)c, (int)i, flippedPos, flippedRot, true)));
    }

    private void _render(class_287 buffer, Vector3f cameraPos, int color, Vector3f pos, Quaternionf orientation, boolean mirrored) {
        List<Vector3f[]> faces = BeatCraftRenderer.getCubeFaces(this.bounds.min, this.bounds.max);
        for (Vector3f[] face : faces) {
            Vector3f c1 = MemoryPool.newVector3f(face[0]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f c2 = MemoryPool.newVector3f(face[1]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f c3 = MemoryPool.newVector3f(face[2]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            Vector3f c4 = MemoryPool.newVector3f(face[3]).mul(1.0f, mirrored ? -1.0f : 1.0f, 1.0f).rotate((Quaternionfc)orientation).add((Vector3fc)pos).sub((Vector3fc)cameraPos);
            buffer.method_22912(c1.x, c1.y, c1.z).method_39415(color);
            buffer.method_22912(c2.x, c2.y, c2.z).method_39415(color);
            buffer.method_22912(c3.x, c3.y, c3.z).method_39415(color);
            buffer.method_22912(c4.x, c4.y, c4.z).method_39415(color);
            MemoryPool.release(c1, c2, c3, c4);
        }
        MemoryPool.release(pos);
        MemoryPool.release(orientation);
    }

    @Override
    protected Vector2f getJumpsXY(float lifetime) {
        float reverseSpawnTime = 1.0f - Math.abs((float)(lifetime - 0.5f)) * 2.0f;
        float jumpTime = Easing.easeOutQuad(reverseSpawnTime);
        Vector2f grid = this.get2DPosition();
        grid.y = Math.lerp((float)(this.doNoteGravity() ? -0.3f : grid.y), (float)grid.y, (float)jumpTime);
        return grid;
    }

    @Override
    protected Vector2f get2DPosition() {
        return new Vector2f(((Obstacle)this.data).getX() * 0.6f - 1.15f, ((Obstacle)this.data).getY() * 0.6f - 0.45f);
    }

    private void updateBounds() {
        this.bounds.min.x = -(((Obstacle)this.data).getWidth() * 0.6f - 0.3f);
        this.bounds.max.y = ((Obstacle)this.data).getHeight() * 0.6f;
        float length = ((Obstacle)this.data).getNjs() * (60.0f / BeatmapPlayer.currentBeatmap.getInfo().getBpm());
        this.bounds.max.z = ((Obstacle)this.data).getLength(length);
    }

    @Override
    public float getJumpOutPosition() {
        float length = ((Obstacle)this.data).getNjs() * (60.0f / BeatmapPlayer.currentBeatmap.getInfo().getBpm());
        return -((Obstacle)this.data).getLength(length);
    }

    @Override
    public float getJumpOutBeat() {
        return ((Obstacle)this.data).getBeat() + ((Obstacle)this.data).getDuration();
    }

    @Override
    public float getDespawnBeat() {
        return super.getDespawnBeat() + ((Obstacle)this.data).getDuration();
    }

    public Hitbox getBounds() {
        return this.bounds;
    }
}

