/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.particle;

import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.mesh.TriangleMesh;
import com.beatcraft.render.particle.Particle;
import com.beatcraft.utils.MathUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import org.apache.logging.log4j.util.BiConsumer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class Debris
implements Particle {
    private final TriangleMesh mesh;
    private final Vector3f position;
    private final Quaternionf orientation;
    private final Vector3f velocity;
    private final Vector3f decay;
    private final Quaternionf spin;
    private final double spawnTime;

    public Debris(Vector3f position, Quaternionf orientation, Vector3f velocity, Quaternionf spin, TriangleMesh mesh) {
        this.mesh = mesh;
        this.position = position;
        this.velocity = velocity;
        this.orientation = orientation;
        this.spin = spin;
        this.decay = new Vector3f(0.99f, 0.99f, 0.99f);
        this.spawnTime = (double)System.nanoTime() / 1.0E9;
    }

    @Override
    public void update(float deltaTime, class_287 buffer, Vector3f cameraPos) {
        this.orientation.add((Quaternionfc)this.spin.mul(deltaTime, new Quaternionf()));
        this.position.add((Vector3fc)this.velocity.mul(deltaTime, new Vector3f()));
        this.velocity.add((Vector3fc)new Vector3f(0.0f, -9.81f, 0.0f).mul(deltaTime));
        this.velocity.mul((Vector3fc)this.decay);
        BeatCraftRenderer.recordNoteRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(tri, cam) -> this.mesh.drawToBuffer((class_287)tri, this.position, this.orientation, (Vector3f)cam)));
    }

    @Override
    public boolean shouldRemove() {
        return MathUtil.inverseLerp(this.spawnTime, this.spawnTime + 5.0, (double)System.nanoTime() / 1.0E9) >= 1.0;
    }
}

