/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.particle;

import com.beatcraft.animation.Easing;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.particle.Particle;
import com.beatcraft.utils.MathUtil;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_327;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class ScoreDisplay
implements Particle {
    private final int score;
    private final double spawnTime;
    private final Vector3f position;
    private final Vector3f endPoint;
    private final Quaternionf orientation;
    private static final Function<Float, Float> easing = Easing.getEasing("easeOutExpo");

    public ScoreDisplay(int score, Vector3f position, Vector3f endPoint, Quaternionf orientation) {
        this.score = score;
        this.position = position;
        this.endPoint = endPoint;
        this.spawnTime = (double)System.nanoTime() / 1.0E9;
        this.orientation = orientation;
    }

    @Override
    public void update(float deltaTime, class_287 buffer, Vector3f cameraPos) {
        float f = (float)MathUtil.inverseLerp(this.spawnTime, this.spawnTime + 1.25, (double)System.nanoTime() / 1.0E9);
        f = Math.clamp(f, 0.0f, 1.0f);
        Vector3f currentPos = MathUtil.lerpVector3(this.position, this.endPoint, easing.apply(Float.valueOf(f)).floatValue()).sub((Vector3fc)cameraPos);
        Matrix4f matrix = new Matrix4f();
        matrix.translate((Vector3fc)currentPos);
        matrix.scale(0.015625f);
        matrix.rotate((Quaternionfc)new Quaternionf().rotateZ((float)Math.PI));
        matrix.rotate((Quaternionfc)this.orientation);
        if (HUDRenderer.vertexConsumerProvider != null) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            String display = String.valueOf(this.score == 0 ? "x" : (this.score == -1 ? "MISS" : Integer.valueOf(this.score)));
            int color = this.score > 100 ? -1 : -7303024;
            int w = textRenderer.method_1727(display);
            textRenderer.method_30882((class_2561)class_2561.method_43470((String)display), (float)(-w) / 2.0f, 0.0f, color, false, matrix, HUDRenderer.vertexConsumerProvider, class_327.class_6415.field_33993, 0, 255);
        }
    }

    @Override
    public boolean shouldRemove() {
        float f = (float)MathUtil.inverseLerp(this.spawnTime, this.spawnTime + 1.25, (double)System.nanoTime() / 1.0E9);
        return (double)f >= 1.25;
    }
}

