/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.replay;

import com.beatcraft.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public record PlayFrame(float beat, Vector3f leftSaberPosition, Quaternionf leftSaberRotation, Vector3f rightSaberPosition, Quaternionf rightSaberRotation) {
    public void write(JsonArray array) {
        JsonObject json = new JsonObject();
        json.addProperty("b", (Number)Float.valueOf(this.beat));
        json.add("lp", PlayFrame.toJson(this.leftSaberPosition));
        json.add("lr", PlayFrame.toJson(this.leftSaberRotation));
        json.add("rp", PlayFrame.toJson(this.rightSaberPosition));
        json.add("rr", PlayFrame.toJson(this.rightSaberRotation));
        array.add((JsonElement)json);
    }

    public static PlayFrame load(JsonObject json) {
        float b = json.get("b").getAsFloat();
        Vector3f lp = JsonUtil.getVector3(json.getAsJsonArray("lp"));
        Quaternionf lr = PlayFrame.getQuaternion(json.getAsJsonArray("lr"));
        Vector3f rp = JsonUtil.getVector3(json.getAsJsonArray("rp"));
        Quaternionf rr = PlayFrame.getQuaternion(json.getAsJsonArray("rr"));
        return new PlayFrame(b, lp, lr, rp, rr);
    }

    public static JsonElement toJson(Vector3f pos) {
        JsonArray json = new JsonArray();
        json.add((Number)Float.valueOf(pos.x));
        json.add((Number)Float.valueOf(pos.y));
        json.add((Number)Float.valueOf(pos.z));
        return json;
    }

    public static JsonElement toJson(Quaternionf rot) {
        JsonArray json = new JsonArray();
        json.add((Number)Float.valueOf(rot.x));
        json.add((Number)Float.valueOf(rot.y));
        json.add((Number)Float.valueOf(rot.z));
        json.add((Number)Float.valueOf(rot.w));
        return json;
    }

    public static Quaternionf getQuaternion(JsonArray json) {
        return new Quaternionf(json.get(0).getAsFloat(), json.get(1).getAsFloat(), json.get(2).getAsFloat(), json.get(3).getAsFloat());
    }
}

