/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.replay;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.replay.PlayFrame;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class PlayRecorder {
    public static String outputFile;
    public static String songName;
    public static String difficultySet;
    public static String difficulty;
    private static final ArrayList<PlayFrame> frames;

    public static void update(float beat) {
        if (outputFile != null && BeatmapPlayer.isPlaying()) {
            frames.add(new PlayFrame(beat, new Vector3f((Vector3fc)GameLogicHandler.leftSaberPos), new Quaternionf((Quaternionfc)GameLogicHandler.leftSaberRotation), new Vector3f((Vector3fc)GameLogicHandler.rightSaberPos), new Quaternionf((Quaternionfc)GameLogicHandler.rightSaberRotation)));
        }
    }

    public static void seek(float beat) {
        frames.removeIf(frame -> frame.beat() >= beat);
    }

    public static void save() throws IOException {
        if (outputFile == null) {
            return;
        }
        String path = class_310.method_1551().field_1697.getAbsolutePath() + "/beatcraft/replay/" + outputFile;
        JsonObject json = new JsonObject();
        json.addProperty("song", songName);
        json.addProperty("set", difficultySet);
        json.addProperty("diff", difficulty);
        JsonArray outputFrames = new JsonArray();
        frames.forEach(frame -> frame.write(outputFrames));
        json.add("frames", (JsonElement)outputFrames);
        Files.writeString(Path.of(path, new String[0]), (CharSequence)json.toString(), new OpenOption[0]);
    }

    public static void reset() {
        frames.clear();
        outputFile = null;
        songName = null;
        difficultySet = null;
        difficulty = null;
    }

    static {
        frames = new ArrayList();
    }
}

