/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.replay;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.audio.BeatmapAudioPlayer;
import com.beatcraft.data.components.ModComponents;
import com.beatcraft.data.menu.SongData;
import com.beatcraft.items.ModItems;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.networking.c2s.BeatSyncC2SPayload;
import com.beatcraft.networking.c2s.MapSyncC2SPayload;
import com.beatcraft.networking.c2s.SaberSyncC2SPayload;
import com.beatcraft.render.effect.SaberRenderer;
import com.beatcraft.replay.PlayFrame;
import com.beatcraft.utils.MathUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class Replayer {
    private static final ArrayList<PlayFrame> frames = new ArrayList();
    public static boolean runReplay = false;
    private static final class_1799 leftSaber = new class_1799((class_1935)ModItems.SABER_ITEM, 1);
    private static final class_1799 rightSaber = new class_1799((class_1935)ModItems.SABER_ITEM, 1);

    public static void loadReplay(String replayFile) throws IOException {
        frames.clear();
        String path = String.valueOf(class_310.method_1551().field_1697) + "/beatcraft/replay/" + replayFile;
        leftSaber.method_57379(ModComponents.AUTO_SYNC_COLOR, (Object)0);
        leftSaber.method_57379(ModComponents.SABER_COLOR_COMPONENT, (Object)0xC03030);
        rightSaber.method_57379(ModComponents.AUTO_SYNC_COLOR, (Object)1);
        rightSaber.method_57379(ModComponents.SABER_COLOR_COMPONENT, (Object)2122920);
        String rawData = Files.readString(Path.of(path, new String[0]));
        JsonObject json = JsonParser.parseString((String)rawData).getAsJsonObject();
        String song = json.get("song").getAsString();
        String set = json.get("set").getAsString();
        String diff = json.get("diff").getAsString();
        JsonArray frameData = json.getAsJsonArray("frames");
        frames.add(new PlayFrame(0.0f, new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf()));
        frameData.forEach(data -> {
            JsonObject obj = data.getAsJsonObject();
            PlayFrame frame = PlayFrame.load(obj);
            frames.add(frame);
        });
        SongData data2 = BeatCraftClient.songs.getFiltered(song).getFirst();
        runReplay = true;
        SongData.BeatmapInfo info = data2.getBeatMapInfo(set, diff);
        try {
            BeatmapPlayer.setupDifficultyFromFile(info.getBeatmapLocation().toString());
            BeatmapAudioPlayer.playAudioFromFile(BeatmapPlayer.currentInfo.getSongFilename());
            BeatmapPlayer.restart();
            GameLogicHandler.reset();
            ClientPlayNetworking.send((class_8710)new MapSyncC2SPayload(data2.getId(), set, diff));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void reset() {
        frames.clear();
        runReplay = false;
    }

    public static void update(float beat) {
        if (!runReplay || beat < 0.0f) {
            return;
        }
        if (frames.isEmpty()) {
            return;
        }
        PlayFrame previous = null;
        PlayFrame next = null;
        int i = 0;
        while (true) {
            if (i >= frames.size()) {
                runReplay = false;
                return;
            }
            if (!(frames.get(i).beat() <= beat)) break;
            previous = frames.get(i);
            next = i + 1 < frames.size() ? frames.get(i + 1) : null;
            ++i;
        }
        if (previous == null || next == null) {
            if (next == null) {
                runReplay = false;
            }
            return;
        }
        float sb = previous.beat();
        float eb = next.beat();
        float f = MathUtil.inverseLerp(sb, eb, beat);
        Vector3f leftSaberPos = MathUtil.lerpVector3(previous.leftSaberPosition(), next.leftSaberPosition(), f);
        Vector3f rightSaberPos = MathUtil.lerpVector3(previous.rightSaberPosition(), next.rightSaberPosition(), f);
        Quaternionf leftSaberRot = MathUtil.lerpQuaternion(previous.leftSaberRotation(), next.leftSaberRotation(), f);
        Quaternionf rightSaberRot = MathUtil.lerpQuaternion(previous.rightSaberRotation(), next.rightSaberRotation(), f);
        GameLogicHandler.updateRightSaber(rightSaberPos, rightSaberRot);
        GameLogicHandler.updateLeftSaber(leftSaberPos, leftSaberRot);
        SaberRenderer.renderReplaySaber(leftSaber, leftSaberPos, leftSaberRot);
        SaberRenderer.renderReplaySaber(rightSaber, rightSaberPos, rightSaberRot);
        ClientPlayNetworking.send((class_8710)new SaberSyncC2SPayload(leftSaberPos, leftSaberRot, rightSaberPos, rightSaberRot));
        ClientPlayNetworking.send((class_8710)new BeatSyncC2SPayload(beat));
    }

    public static void seek(float beat) {
    }
}

