/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.screen;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatCraftClient;
import com.beatcraft.data.menu.FileDownloader;
import com.beatcraft.data.menu.SongDownloader;
import com.beatcraft.data.menu.song_preview.SongPreview;
import com.beatcraft.render.dynamic_loader.DynamicTexture;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class SongDownloaderScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_437 parent;
    private TextBoxComponent search;
    private FlowLayout listComponent;
    private FlowLayout previewComponent;
    private LabelComponent pageDisplay;
    private FlowLayout coverContainer;
    private DynamicTexture coverImage;
    private static final Queue<Runnable> listUpdateQueue = new ConcurrentLinkedQueue<Runnable>();

    public SongDownloaderScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.beatcraft.song_downloader"));
        this.parent = parent;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout flowLayout) {
        SongDownloader.loadFromSearch(this::updateList);
        this.search = (TextBoxComponent)Components.textBox((Sizing)Sizing.fill((int)80), (String)SongDownloader.search).positioning(Positioning.relative((int)50, (int)1));
        this.search.field_22763 = true;
        this.search.onChanged().subscribe(this::updateSearch);
        this.listComponent = Components.list(SongDownloader.songPreviews, this::previewLayoutConfigurator, this::makeSongPreviewDisplay, (boolean)true);
        this.pageDisplay = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)String.format("PAGE %s", SongDownloader.page + 1))).lineHeight(15).tooltip((class_2561)class_2561.method_43471((String)"gui.beatcraft.button.page_error"));
        this.previewComponent = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fill());
        flowLayout.surface(Surface.VANILLA_TRANSLUCENT);
        flowLayout.child((Component)this.search).child((Component)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fill((int)90)).child((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)50), (Sizing)Sizing.fill()).child((Component)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content()).child((Component)Components.box((Sizing)Sizing.fill((int)5), (Sizing)Sizing.fixed((int)2)).color(Color.ofArgb((int)0))).child((Component)Components.button((class_2561)class_2561.method_43470((String)" < "), this::pageLeft)).child((Component)Components.box((Sizing)Sizing.fill((int)25), (Sizing)Sizing.fixed((int)2)).color(Color.ofArgb((int)0))).child((Component)this.pageDisplay).child((Component)Components.box((Sizing)Sizing.fill((int)25), (Sizing)Sizing.fixed((int)2)).color(Color.ofArgb((int)0))).child((Component)Components.button((class_2561)class_2561.method_43470((String)" > "), this::pageRight))).child((Component)Containers.verticalScroll((Sizing)Sizing.content(), (Sizing)Sizing.fill((int)90), (Component)this.listComponent))).child((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)50), (Sizing)Sizing.content()).child((Component)this.previewComponent)).positioning(Positioning.relative((int)0, (int)100)));
    }

    private void pageLeft(ButtonComponent button) {
        SongDownloader.pageLeft(this::updateList);
    }

    private void pageRight(ButtonComponent button) {
        SongDownloader.pageRight(this::updateList);
    }

    protected void previewLayoutConfigurator(FlowLayout layout) {
    }

    protected Component makeSongPreviewDisplay(SongPreview preview) {
        FlowLayout layoutA = Containers.horizontalFlow((Sizing)Sizing.fixed((int)450), (Sizing)Sizing.fixed((int)30));
        FlowLayout layoutB = Containers.verticalFlow((Sizing)Sizing.fill((int)45), (Sizing)Sizing.fill());
        Component openButton = Components.button((class_2561)class_2561.method_43470((String)" > "), b -> this.openPreview((ButtonComponent)b, preview)).positioning(Positioning.relative((int)45, (int)0));
        ScrollContainer titleScroll = Containers.horizontalScroll((Sizing)Sizing.fill((int)65), (Sizing)Sizing.content(), (Component)Components.label((class_2561)class_2561.method_43470((String)preview.name())));
        layoutB.child((Component)titleScroll).child((Component)Components.label((class_2561)class_2561.method_43470((String)preview.metaData().levelAuthorName())));
        layoutA.child((Component)Components.spacer((int)5)).child((Component)layoutB).child(openButton);
        return layoutA;
    }

    private void setCoverImage() {
        this.coverContainer.clearChildren();
        if (this.coverImage != null) {
            this.coverImage.unloadTexture();
            this.coverImage = null;
        }
        try {
            this.coverImage = new DynamicTexture(String.valueOf(class_310.method_1551().field_1697) + "/beatcraft/temp/cover.png");
            this.coverContainer.child((Component)Components.texture((class_2960)this.coverImage.id(), (int)0, (int)0, (int)100, (int)100, (int)this.coverImage.width(), (int)this.coverImage.height()));
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to change image!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void openPreview(ButtonComponent button, SongPreview preview) {
        this.previewComponent.clearChildren();
        this.coverContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        this.coverContainer.child((Component)Components.texture((class_2960)class_2960.method_60655((String)"beatcraft", (String)"textures/gui/song_downloader/default_cover.png"), (int)0, (int)0, (int)100, (int)100, (int)256, (int)256)).horizontalAlignment(HorizontalAlignment.CENTER);
        FileDownloader.downloadCoverImage(preview.versions().getFirst().coverURL(), String.valueOf(class_310.method_1551().field_1697) + "/beatcraft/temp/cover.png", this::setCoverImage);
        this.previewComponent.child((Component)this.coverContainer).child((Component)Containers.horizontalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.content(), (Component)Components.label((class_2561)class_2561.method_43470((String)preview.name())))).child((Component)Containers.horizontalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.content(), (Component)Components.label((class_2561)class_2561.method_43470((String)(preview.metaData().songName() + " - " + preview.metaData().songAuthorName()))))).child((Component)Containers.horizontalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.content(), (Component)Components.label((class_2561)class_2561.method_43470((String)preview.metaData().levelAuthorName())))).child((Component)Containers.horizontalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.content(), (Component)Components.label((class_2561)class_2561.method_43470((String)preview.getSets())))).child((Component)Containers.horizontalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.content(), (Component)Components.label((class_2561)class_2561.method_43470((String)preview.getDiffs())))).child((Component)Components.button((class_2561)class_2561.method_43471((String)"gui.beatcraft.download_song"), b -> this.downloadSong((ButtonComponent)b, preview))).horizontalAlignment(HorizontalAlignment.CENTER);
    }

    private void downloadSong(ButtonComponent button, SongPreview preview) {
        SongDownloader.downloadSong(preview, class_310.method_1551().field_1697.getAbsolutePath(), BeatCraftClient.songs::loadSongs);
    }

    public void method_25393() {
        while (!listUpdateQueue.isEmpty()) {
            Runnable call = listUpdateQueue.poll();
            if (call == null) continue;
            call.run();
        }
        super.method_25393();
    }

    protected void updateList() {
        listUpdateQueue.add(() -> {
            this.listComponent.clearChildren();
            SongDownloader.listModifyLock.lock();
            SongDownloader.songPreviews.forEach(preview -> this.listComponent.child(this.makeSongPreviewDisplay((SongPreview)preview)));
            SongDownloader.listModifyLock.unlock();
            this.pageDisplay.text((class_2561)class_2561.method_43470((String)String.format("PAGE %s", SongDownloader.page + 1)));
        });
    }

    protected void updateSearch(String content) {
        if (!SongDownloader.search.equals(content)) {
            SongDownloader.search = content;
            SongDownloader.loadFromSearch(this::updateList);
        }
    }

    public void method_25419() {
        if (this.coverImage != null) {
            this.coverImage.unloadTexture();
            this.coverImage = null;
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }
}

