/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.utils;

import com.beatcraft.data.types.Color;
import com.beatcraft.memory.MemoryPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2382;
import net.minecraft.class_3545;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class MathUtil {
    public static final float DEG2RAD = (float)Math.PI / 180;
    public static final float RAD2DEG = 57.295776f;

    public static float inverseLerp(float a, float b, float t) {
        return (t - a) / (b - a);
    }

    public static double inverseLerp(double a, double b, double t) {
        return (t - a) / (b - a);
    }

    public static float clamp01(float x) {
        return org.joml.Math.clamp((float)0.0f, (float)1.0f, (float)x);
    }

    public static float secondsToBeats(float seconds, float bpm) {
        return seconds * (bpm / 60.0f);
    }

    public static float beatsToSeconds(float beats, float bpm) {
        return beats * (60.0f / bpm);
    }

    public static Quaternionf eulerToQuaternion(Vector3f euler) {
        Quaternionf q = new Quaternionf();
        q.rotateY(euler.y * ((float)Math.PI / 180));
        q.rotateX(euler.x * ((float)Math.PI / 180));
        q.rotateZ(euler.z * ((float)Math.PI / 180));
        return q;
    }

    public static float normalizeAngle(float angle) {
        return (angle %= 360.0f) < 0.0f ? angle + 360.0f : angle;
    }

    public static float degreesBetween(float a, float b) {
        a = MathUtil.normalizeAngle(a);
        b = MathUtil.normalizeAngle(b);
        float difference = org.joml.Math.abs((float)(a - b));
        return org.joml.Math.min((float)difference, (float)(360.0f - difference));
    }

    public static float getVectorAngleDegrees(Vector2f v) {
        float radians = org.joml.Math.atan2((float)v.y, (float)v.x);
        return (float)org.joml.Math.toDegrees((double)radians);
    }

    public static void reflectMatrixAcrossX(Matrix4f matrix) {
        matrix.m30(matrix.m30() * -1.0f);
        matrix.m10(matrix.m10() * -1.0f);
        matrix.m20(matrix.m20() * -1.0f);
        matrix.m01(matrix.m01() * -1.0f);
        matrix.m02(matrix.m02() * -1.0f);
    }

    public static Vector3f matrixTransformPoint3D(Matrix4f matrix, Vector3f point) {
        Vector4f newPoint = new Vector4f((Vector3fc)point, 1.0f);
        newPoint.mul((Matrix4fc)matrix);
        return new Vector3f(newPoint.x, newPoint.y, newPoint.z);
    }

    public static Vector2f lerpVector2(Vector2f a, Vector2f b, float time) {
        return new Vector2f((Vector2fc)a).lerp((Vector2fc)b, time);
    }

    public static Vector3f lerpVector3(Vector3f a, Vector3f b, float time) {
        return new Vector3f((Vector3fc)a).lerp((Vector3fc)b, time);
    }

    public static class_2382 lerpVec3i(class_2382 a, class_2382 b, float time) {
        return new class_2382((int)org.joml.Math.lerp((float)a.method_10263(), (float)b.method_10263(), (float)time), (int)org.joml.Math.lerp((float)a.method_10264(), (float)b.method_10264(), (float)time), (int)org.joml.Math.lerp((float)a.method_10260(), (float)b.method_10260(), (float)time));
    }

    public static float inverseLerpVector3(Vector3f a, Vector3f b, Vector3f t) {
        if (a.x != b.x) {
            return MathUtil.inverseLerp(a.x, b.x, t.x);
        }
        if (a.y != b.y) {
            return MathUtil.inverseLerp(a.y, b.y, t.y);
        }
        return MathUtil.inverseLerp(a.z, b.z, t.z);
    }

    public static Vector4f lerpVector4(Vector4f a, Vector4f b, float time) {
        return new Vector4f((Vector4fc)a).lerp((Vector4fc)b, time);
    }

    public static Quaternionf lerpQuaternion(Quaternionf a, Quaternionf b, float time) {
        return new Quaternionf((Quaternionfc)a).slerp((Quaternionfc)b, time);
    }

    public static Vector3f[] generateCircle(Vector3f normal, float radius, int pointsCount, Vector3f offset) {
        return MathUtil.generateCircle(normal, radius, pointsCount, offset, 360.0f, 0.0f);
    }

    public static Vector3f[] generateCircle(Vector3f normal, float radius, int pointsCount, Vector3f offset, float arcDegrees, float angleOffset) {
        normal.normalize();
        Vector3f startPoint = new Vector3f(1.0f, 0.0f, 0.0f);
        if (startPoint.dot((Vector3fc)normal) > 0.99f) {
            startPoint.set(0.0f, 1.0f, 0.0f);
        }
        startPoint.cross((Vector3fc)normal).normalize().mul(radius);
        Vector3f[] points = new Vector3f[pointsCount + 1];
        Quaternionf rotation = new Quaternionf();
        for (int i = 0; i <= pointsCount; ++i) {
            float angle = arcDegrees * ((float)Math.PI / 180) * (float)i / (float)pointsCount + angleOffset * ((float)Math.PI / 180);
            rotation.fromAxisAngleRad(normal.x, normal.y, normal.z, angle);
            points[i] = MemoryPool.newVector3f(startPoint).rotate((Quaternionfc)rotation).add((Vector3fc)offset);
        }
        return points;
    }

    public static class_3545<Float, Vector3f> getLineDistance(Vector3f startA, Vector3f endA, Vector3f startB, Vector3f endB) {
        float modB;
        float modA;
        Vector3f distA = new Vector3f((Vector3fc)endA).sub((Vector3fc)startA);
        Vector3f distB = new Vector3f((Vector3fc)endB).sub((Vector3fc)startB);
        Vector3f startDiff = new Vector3f((Vector3fc)startA).sub((Vector3fc)startB);
        float distA2 = distA.dot((Vector3fc)distA);
        float distB2 = distB.dot((Vector3fc)distB);
        float f = distB.dot((Vector3fc)startDiff);
        if (distA2 <= Float.MIN_VALUE && distB2 <= Float.MIN_VALUE) {
            return new class_3545((Object)Float.valueOf(startDiff.length()), (Object)new Vector3f());
        }
        if (distA2 <= Float.MIN_VALUE) {
            modA = 0.0f;
            modB = org.joml.Math.max((float)0.0f, (float)org.joml.Math.min((float)1.0f, (float)(f / distB2)));
        } else {
            float dotA = distA.dot((Vector3fc)startDiff);
            if (distB2 <= Float.MIN_VALUE) {
                modB = 0.0f;
                modA = org.joml.Math.max((float)0.0f, (float)org.joml.Math.min((float)1.0f, (float)(-dotA / distA2)));
            } else {
                float dotAB;
                float denominator = distA2 * distB2 - (dotAB = distA.dot((Vector3fc)distB)) * dotAB;
                modA = denominator != 0.0f ? org.joml.Math.max((float)0.0f, (float)org.joml.Math.min((float)1.0f, (float)((dotAB * f - dotA * distB2) / denominator))) : 0.0f;
                modB = (dotAB * modA + f) / distB2;
                if (modB < 0.0f) {
                    modB = 0.0f;
                    modA = org.joml.Math.max((float)0.0f, (float)org.joml.Math.min((float)1.0f, (float)(-dotA / distA2)));
                } else if (modB > 1.0f) {
                    modB = 1.0f;
                    modA = org.joml.Math.max((float)0.0f, (float)org.joml.Math.min((float)1.0f, (float)((dotAB - dotA) / distA2)));
                }
            }
        }
        Vector3f closestA = new Vector3f((Vector3fc)distA).mul(modA).add((Vector3fc)startA);
        Vector3f closestB = new Vector3f((Vector3fc)distB).mul(modB).add((Vector3fc)startB);
        return new class_3545((Object)Float.valueOf(closestA.distance((Vector3fc)closestB)), (Object)MathUtil.lerpVector3(closestA, closestB, 0.5f));
    }

    public static String timeToString(int t) {
        int minutes = t / 60;
        int seconds = t % 60;
        return String.format("%s:%02d", minutes, seconds);
    }

    public static Color lerpColor(Color a, Color b, float time) {
        return new Color(org.joml.Math.clamp((float)org.joml.Math.lerp((float)a.getRed(), (float)b.getRed(), (float)time), (float)0.0f, (float)255.0f), org.joml.Math.clamp((float)org.joml.Math.lerp((float)a.getGreen(), (float)b.getGreen(), (float)time), (float)0.0f, (float)255.0f), org.joml.Math.clamp((float)org.joml.Math.lerp((float)a.getBlue(), (float)b.getBlue(), (float)time), (float)0.0f, (float)255.0f), org.joml.Math.clamp((float)org.joml.Math.lerp((float)a.getAlpha(), (float)b.getAlpha(), (float)time), (float)0.0f, (float)255.0f));
    }

    public static class_3545<Vector3f, Vector2f> raycastPlane(Vector3f raycastOrigin, Quaternionf raycastOrientation, Vector3f planeCenter, Quaternionf planeOrientation, Vector2f planeSize) {
        Vector3f planeNormal = new Vector3f(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)planeOrientation);
        Vector3f rayDirection = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)raycastOrientation);
        float denominator = rayDirection.dot((Vector3fc)planeNormal);
        if ((double)org.joml.Math.abs((float)denominator) < 1.0E-6) {
            return null;
        }
        float t = planeCenter.sub((Vector3fc)raycastOrigin, new Vector3f()).dot((Vector3fc)planeNormal) / denominator;
        if (t < 0.0f) {
            return null;
        }
        Vector3f intersection = new Vector3f((Vector3fc)raycastOrigin).fma(t, (Vector3fc)rayDirection);
        Vector3f localPoint = intersection.sub((Vector3fc)planeCenter, new Vector3f()).rotate((Quaternionfc)new Quaternionf((Quaternionfc)planeOrientation).invert());
        if (org.joml.Math.abs((float)localPoint.x) > planeSize.x / 2.0f || org.joml.Math.abs((float)localPoint.y) > planeSize.y / 2.0f) {
            return null;
        }
        return new class_3545((Object)intersection, (Object)new Vector2f(localPoint.x, localPoint.y));
    }

    public static boolean check2DPointCollision(Vector2f point, Vector2f center, Vector2f size) {
        Vector2f minCorner = center.sub((Vector2fc)size.mul(0.5f, new Vector2f()), new Vector2f());
        Vector2f maxCorner = center.add((Vector2fc)size.mul(0.5f, new Vector2f()), new Vector2f());
        return minCorner.x <= point.x && point.x <= maxCorner.x && minCorner.y <= point.y && point.y <= maxCorner.y;
    }

    public static List<Vector3f[]> fillMesh(Vector3f[] vertices) {
        if (vertices.length < 3) {
            return List.of();
        }
        ArrayList<Vector3f> points = new ArrayList<Vector3f>(Arrays.stream(vertices).toList());
        Vector3f p0 = points.removeFirst();
        Vector3f p1 = points.removeFirst();
        ArrayList<Vector3f[]> tris = new ArrayList<Vector3f[]>();
        for (Vector3f p2 : points) {
            tris.add(new Vector3f[]{p0, p1, p2});
            p1 = p2;
        }
        return tris;
    }
}

