/*
 * Decompiled with CFR 0.152.
 */
package me.tinyoverflow.privatestatus;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import me.tinyoverflow.privatestatus.events.AddAddressEvent;
import me.tinyoverflow.privatestatus.events.ExpireAddressEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class AddressRepository {
    private final Logger logger;
    private final HashMap<OfflinePlayer, InetAddress> storage = new HashMap();

    public AddressRepository(Logger logger) {
        this.logger = logger;
    }

    public void fromMap(@NotNull Map<String, Object> configMap) {
        this.storage.clear();
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            UUID uuid = UUID.fromString(entry.getKey());
            String encodedAddress = (String)entry.getValue();
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            ExpireAddressEvent event = new ExpireAddressEvent(offlinePlayer);
            if (event.callEvent()) {
                this.logger.info("Skipping expired address for " + uuid);
                continue;
            }
            try {
                InetAddress inetAddress = InetAddress.getByAddress(Base64.getDecoder().decode(encodedAddress));
                this.storage.put(offlinePlayer, inetAddress);
            }
            catch (UnknownHostException e) {
                this.logger.warning("Unknown host found in config. Skipping: " + encodedAddress);
            }
        }
        this.logger.info("Loaded " + this.storage.size() + " addresses from configuration.");
    }

    public Map<String, String> toMap() {
        HashMap<String, String> addressList = new HashMap<String, String>();
        for (Map.Entry<OfflinePlayer, InetAddress> entry : this.storage.entrySet()) {
            UUID uuid = entry.getKey().getUniqueId();
            InetAddress inetAddress = entry.getValue();
            addressList.put(uuid.toString(), Base64.getEncoder().encodeToString(inetAddress.getAddress()));
        }
        return addressList;
    }

    public boolean hasAddress(InetAddress inetAddress) {
        return this.storage.containsValue(inetAddress);
    }

    public void add(OfflinePlayer offlinePlayer, InetAddress inetAddress) {
        AddAddressEvent event = new AddAddressEvent(offlinePlayer, inetAddress);
        if (event.callEvent()) {
            this.storage.put(offlinePlayer, inetAddress);
        }
    }
}

