/*
 * Decompiled with CFR 0.152.
 */
package me.tinyoverflow.privatestatus;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import me.tinyoverflow.privatestatus.AddressRepository;
import me.tinyoverflow.privatestatus.events.ExpireAddressEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PrivateStatus
extends JavaPlugin
implements Listener {
    private final String CONFIG_EXPIRATION_DAYS = "expiration-days";
    private final String CONFIG_KNOWN_ADDRESSES = "known-addresses";
    private AddressRepository repository;

    public void onLoad() {
        this.repository = new AddressRepository(this.getLogger());
        this.getConfig().options().copyDefaults(true);
        this.getConfig().addDefault("expiration-days", (Object)3);
        this.getConfig().setComments("expiration-days", List.of("The amount of days after which addresses will expire. Minimum: 1."));
        this.getConfig().addDefault("known-addresses", new HashMap());
        this.getConfig().setComments("known-addresses", List.of("A list of already known addresses."));
        this.saveConfig();
    }

    public void onEnable() {
        ConfigurationSection configurationSection;
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.getConfig().getInt("expiration-days") < 1) {
            this.getConfig().set("expiration-days", (Object)3);
        }
        if ((configurationSection = this.getConfig().getConfigurationSection("known-addresses")) != null) {
            this.repository.fromMap(configurationSection.getValues(false));
        }
    }

    public void onDisable() {
        this.getConfig().set("known-addresses", this.repository.toMap());
        this.saveConfig();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        InetSocketAddress socketAddress = player.getAddress();
        if (socketAddress == null) {
            this.getLogger().log(Level.WARNING, "Could not retrieve IP address of player " + player.getName());
            return;
        }
        InetAddress address = socketAddress.getAddress();
        if (address.isAnyLocalAddress()) {
            this.getLogger().log(Level.INFO, "Player " + player.getName() + " joined with local address. Ignoring.");
            return;
        }
        this.repository.add((OfflinePlayer)player, address);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onServerListPingEvent(PaperServerListPingEvent event) {
        if (!this.repository.hasAddress(event.getAddress())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExpireAddressEvent(ExpireAddressEvent event) {
        int expirationDays = this.getConfig().getInt("expiration-days");
        long expirationDeadline = new Date().getTime() - (long)expirationDays * 86400000L;
        event.setCancelled(event.getPlayer().getLastLogin() >= expirationDeadline);
    }
}

