/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.mechanicalfryer;

import com.pyzpre.createbitterballen.block.mechanicalfryer.DeepFryingRecipe;
import com.pyzpre.createbitterballen.block.mechanicalfryer.MechanicalFryerEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.simple.DeferralBehaviour;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FryerOperatingBlockEntity
extends KineticBlockEntity {
    public DeferralBehaviour basinChecker;
    public boolean basinRemoved;
    protected Recipe<?> currentRecipe;

    public FryerOperatingBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void sendData() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        BlockState state = this.getBlockState();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.level.getChunkAt(this.worldPosition).setBlockEntity((BlockEntity)this);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.basinChecker = new DeferralBehaviour((SmartBlockEntity)this, this::updateBasin);
        behaviours.add((BlockEntityBehaviour)this.basinChecker);
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.getSpeed();
        this.basinRemoved = false;
        this.basinChecker.scheduleUpdate();
    }

    protected boolean updateBasin() {
        if (!this.isSpeedRequirementFulfilled()) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return true;
        }
        if (this.isRunning()) {
            return true;
        }
        if (this.level == null || this.level.isClientSide) {
            return true;
        }
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.filter(BasinBlockEntity::canContinueProcessing).isEmpty()) {
            return true;
        }
        List<Recipe<?>> recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    protected abstract boolean isRunning();

    public void startProcessingBasin() {
    }

    protected <C extends RecipeInput> boolean matchFryingRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional<BasinBlockEntity> basinOptional = this.getBasin();
        if (basinOptional.isEmpty()) {
            return false;
        }
        BasinBlockEntity basin = basinOptional.get();
        FryerOperatingBlockEntity fryerOperatingBlockEntity = this;
        if (!(fryerOperatingBlockEntity instanceof MechanicalFryerEntity)) {
            return false;
        }
        MechanicalFryerEntity fryer = (MechanicalFryerEntity)fryerOperatingBlockEntity;
        return DeepFryingRecipe.match(basin, fryer, recipe);
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        Optional<BasinBlockEntity> basinOptional = this.getBasin();
        if (basinOptional.map(BasinBlockEntity::isEmpty).orElse(true).booleanValue()) {
            return new ArrayList();
        }
        List holders = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.level, this::matchStaticFilters);
        return holders.stream().map(RecipeHolder::value).filter(this::matchFryingRecipe).sorted((r1, r2) -> r2.getIngredients().size() - r1.getIngredients().size()).collect(Collectors.toList());
    }

    protected abstract void onBasinRemoved();

    protected Optional<BasinBlockEntity> getBasin() {
        if (this.level == null) {
            return Optional.empty();
        }
        BlockEntity basinBE = this.level.getBlockEntity(this.worldPosition.below(2));
        if (!(basinBE instanceof BasinBlockEntity)) {
            return Optional.empty();
        }
        return Optional.of((BasinBlockEntity)basinBE);
    }

    protected abstract boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> var1);

    protected abstract Object getRecipeCacheKey();
}

