/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.events;

import com.pyzpre.createbitterballen.entity.HerringModel;
import com.pyzpre.createbitterballen.entity.HerringRenderer;
import com.pyzpre.createbitterballen.index.EffectRegistry;
import com.pyzpre.createbitterballen.index.EntityRegistry;
import com.pyzpre.createbitterballen.util.DeepfriedSoundInstance;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="create_bic_bit", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEventSubscriber {
    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.HERRING.get(), HerringRenderer::new);
    }

    @SubscribeEvent
    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(HerringModel.LAYER_LOCATION, HerringModel::createBodyLayer);
    }

    @Mod.EventBusSubscriber(modid="create_bic_bit", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public class SoundModifier {
        @SubscribeEvent
        public static void onPlaySound(PlaySoundEvent event) {
            SoundInstance originalSound;
            MobEffectInstance effect;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && (effect = mc.f_91074_.m_21124_((MobEffect)EffectRegistry.OILED_UP.get())) != null && effect.m_19564_() >= 2 && (originalSound = event.getOriginalSound()) != null) {
                ResourceLocation soundLocation = originalSound.m_7904_();
                if (soundLocation.toString().equals("minecraft:entity.minecart.inside") || soundLocation.toString().equals("minecraft:entity.minecart.riding") || soundLocation.toString().equals("create:cogs") || soundLocation.toString().equals("minecraft:entity.minecart.inside.underwater")) {
                    event.setSound(null);
                    return;
                }
                Random random = new Random();
                float basePitch = 0.5f;
                float pitchVariation = 0.2f;
                float baseVolume = 1.2f;
                float volumeVariation = 0.3f;
                float newPitch = basePitch + random.nextFloat() * pitchVariation;
                float newVolume = baseVolume + random.nextFloat() * volumeVariation;
                DeepfriedSoundInstance modifiedSound = new DeepfriedSoundInstance(originalSound.m_7904_(), originalSound.m_8070_(), newVolume, newPitch, originalSound.m_7775_(), originalSound.m_7766_(), SoundInstance.Attenuation.LINEAR, originalSound.m_7772_(), originalSound.m_7780_(), originalSound.m_7778_());
                modifiedSound.m_6775_(mc.m_91106_());
                event.setSound((SoundInstance)modifiedSound);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="create_bic_bit", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public class ClientSetup {
        private static PostChain grayscaleShader;
        private static int lastWidth;
        private static int lastHeight;

        public static void initShader() {
            try {
                Minecraft mc = Minecraft.m_91087_();
                ResourceLocation shaderRL = new ResourceLocation("create_bic_bit", "shaders/post/deepfried_effect.json");
                grayscaleShader = new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), shaderRL);
                if (grayscaleShader == null) {
                    return;
                }
                grayscaleShader.m_110025_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
                lastWidth = mc.m_91268_().m_85441_();
                lastHeight = mc.m_91268_().m_85442_();
            }
            catch (Exception e) {
                e.printStackTrace();
                grayscaleShader = null;
            }
        }

        @SubscribeEvent
        public static void onRenderLevelStage(RenderLevelStageEvent event) {
            if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                int amplifier;
                MobEffectInstance effect = mc.f_91074_.m_21124_((MobEffect)EffectRegistry.OILED_UP.get());
                if (effect != null && (amplifier = effect.m_19564_()) >= 2) {
                    if (grayscaleShader == null) {
                        ClientSetup.initShader();
                    }
                    ClientSetup.resizeShaderIfNeeded();
                    if (grayscaleShader != null) {
                        try {
                            grayscaleShader.m_110023_(event.getPartialTick());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return;
                }
                if (grayscaleShader != null) {
                    grayscaleShader.close();
                    grayscaleShader = null;
                }
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            ClientSetup.resizeShaderIfNeeded();
        }

        private static void resizeShaderIfNeeded() {
            Minecraft mc = Minecraft.m_91087_();
            if (grayscaleShader != null) {
                int currentWidth = mc.m_91268_().m_85441_();
                int currentHeight = mc.m_91268_().m_85442_();
                if (currentWidth != lastWidth || currentHeight != lastHeight) {
                    lastWidth = currentWidth;
                    lastHeight = currentHeight;
                    try {
                        grayscaleShader.m_110025_(currentWidth, currentHeight);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        static {
            lastWidth = -1;
            lastHeight = -1;
        }
    }
}

