/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.cheese;

import com.pyzpre.createbitterballen.block.cheese.WaxedAgedCheeseBlock;
import com.pyzpre.createbitterballen.index.BlockRegistry;
import com.pyzpre.createbitterballen.index.ItemRegistry;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class AgedCheeseBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    public static final BooleanProperty WAXED = BooleanProperty.m_61465_((String)"waxed");
    private static final VoxelShape SHAPE = AgedCheeseBlock.makeShape();

    public AgedCheeseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        return Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5, (double)0.9375);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Item usedItem = itemStack.m_41720_();
        if (!world.f_46443_) {
            if (usedItem == Items.f_42784_) {
                if (this.handleWaxing(world, pos, state, player, itemStack)) {
                    return InteractionResult.SUCCESS;
                }
            } else if ((itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "shears"))) || itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/knives")))) && this.handleShearing(world, pos, state)) {
                this.playShearingEffect(world, pos);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private boolean handleWaxing(Level world, BlockPos pos, BlockState state, Player player, ItemStack itemStack) {
        if (!((Boolean)state.m_61143_((Property)WAXED)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(true)), 3);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            this.playWaxOnEffect(world, pos);
            world.m_186460_(pos, (Block)this, 1);
            return true;
        }
        return false;
    }

    private void transition(ServerLevel world, BlockPos pos, BlockState state) {
        BlockState agedCheeseState = (BlockState)((BlockState)((WaxedAgedCheeseBlock)((Object)BlockRegistry.WAXED_AGED_CHEESE.get())).m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(2))).m_61124_((Property)WAXED, (Comparable)Boolean.valueOf(true));
        world.m_46597_(pos, agedCheeseState);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (((Boolean)state.m_61143_((Property)WAXED)).booleanValue()) {
            this.transition(world, pos, state);
        }
    }

    private boolean handleShearing(Level world, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age == 1 || age == 2) {
            this.dropCheeseProducts(world, pos, age);
            world.m_7471_(pos, false);
            this.playShearingEffect(world, pos);
            return true;
        }
        return false;
    }

    private void playWaxOnEffect(Level world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            for (int i = 0; i < 20; ++i) {
                double d0 = serverWorld.f_46441_.m_188583_() * 0.1;
                double d1 = serverWorld.f_46441_.m_188583_() * 0.1;
                double d2 = serverWorld.f_46441_.m_188583_() * 0.1;
                double x = (double)pos.m_123341_() + 0.5 + serverWorld.f_46441_.m_188583_() * 0.5;
                double y = (double)pos.m_123342_() + 0.6;
                double z = (double)pos.m_123343_() + 0.5 + serverWorld.f_46441_.m_188583_() * 0.5;
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175828_, x, y, z, 1, d0, d1, d2, 0.0);
            }
        }
    }

    private void playWaxOffEffect(Level world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void dropCheeseProducts(Level world, BlockPos pos, int age) {
        ItemStack dropItem = age == 1 ? new ItemStack(ItemRegistry.YOUNG_CHEESE_WEDGE) : new ItemStack(ItemRegistry.AGED_CHEESE_WEDGE);
        RandomSource random = world.f_46441_;
        for (int i = 0; i < 4; ++i) {
            double d0 = random.m_188501_() * 0.7f + 0.15f;
            double d1 = (double)(random.m_188501_() * 0.7f + 0.060000002f) + 0.6;
            double d2 = random.m_188501_() * 0.7f + 0.15f;
            ItemStack itemStackCopy = dropItem.m_41777_();
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemStackCopy);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
    }

    private void playShearingEffect(Level world, BlockPos pos) {
        world.m_5594_(null, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, WAXED});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        FontHelper.Palette palette = FontHelper.Palette.STANDARD_CREATE;
        tooltip.add((Component)TooltipHelper.holdShift((FontHelper.Palette)FontHelper.Palette.STANDARD_CREATE, (boolean)true));
        if (Screen.m_96638_()) {
            MutableComponent part1 = Component.m_237115_((String)"item.create_bic_bit.cheese.tooltip.part1").m_130948_(palette.primary());
            MutableComponent part2 = Component.m_237115_((String)"item.create_bic_bit.cheese.tooltip.part2").m_130948_(palette.highlight());
            MutableComponent part3 = Component.m_237115_((String)"item.create_bic_bit.cheese.tooltip.part3").m_130948_(palette.primary());
            tooltip.add((Component)part1.m_7220_((Component)part2).m_7220_((Component)part3));
        }
    }
}

