/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.effect;

import java.util.Random;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class OiledUpEffect
extends MobEffect {
    private static final Random random = new Random();
    private static final double DROP_ITEM_CHANCE = 0.01;
    private static final double FALL_OFF_LADDER_CHANCE = 0.02;

    public OiledUpEffect(MobEffectCategory mobEffectCategory, int color) {
        super(mobEffectCategory, color);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level world = entity.m_20193_();
        this.maybeFloatInWater(entity);
        if (amplifier >= 1) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.maybeDropHeldItem(player, amplifier);
            }
            this.maybeFallOffLadder(entity);
            if (world.m_46471_()) {
                this.applyLevitationEffect(entity);
            }
        }
    }

    private void maybeDropHeldItem(Player player, int amplifier) {
        ItemStack itemStack;
        double baseDivisor = 2.0;
        double adjustedDropChance = 0.01 / (baseDivisor + Math.sqrt(amplifier + 1));
        if (!player.m_9236_().f_46443_ && random.nextDouble() < adjustedDropChance && !(itemStack = player.m_21205_()).m_41619_()) {
            player.m_7197_(itemStack, false, false);
            player.m_21008_(player.m_7655_(), ItemStack.f_41583_);
        }
    }

    private void maybeFloatInWater(LivingEntity entity) {
        if (entity.m_20069_() && !entity.m_9236_().m_8055_(entity.m_20183_().m_7494_()).m_60795_()) {
            double upwardForce = 0.1;
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, upwardForce, 0.0));
        }
    }

    private void applyLevitationEffect(LivingEntity entity) {
        MobEffectInstance levitation = new MobEffectInstance(MobEffects.f_19620_, 20, 0);
        entity.m_7292_(levitation);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.grantAdvancementCriterion(serverPlayer, "create_bic_bit:step_3", "got_levitation");
        }
    }

    private void grantAdvancementCriterion(ServerPlayer player, String advancementID, String criterionKey) {
        AdvancementProgress advancementProgress;
        PlayerAdvancements playerAdvancements = player.m_8960_();
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation(advancementID));
        if (advancement != null && advancement.m_138325_().containsKey(criterionKey) && !(advancementProgress = playerAdvancements.m_135996_(advancement)).m_8193_()) {
            playerAdvancements.m_135988_(advancement, criterionKey);
        }
    }

    private void maybeFallOffLadder(LivingEntity entity) {
        boolean isOnLadder;
        boolean bl = isOnLadder = entity.m_9236_().m_8055_(entity.m_20183_()).m_204336_(BlockTags.f_13082_) || entity.m_9236_().m_8055_(entity.m_20183_().m_7494_()).m_204336_(BlockTags.f_13082_);
        if (isOnLadder && random.nextDouble() < 0.02) {
            Vec3 lookVector = entity.m_20154_();
            Vec3 pushVector = new Vec3(-lookVector.f_82479_, 0.0, -lookVector.f_82481_).m_82541_().m_82490_(0.15);
            entity.m_20256_(entity.m_20184_().m_82549_(pushVector));
        }
    }
}

