/*
 * Decompiled with CFR 0.152.
 */
package minimotd.org.spongepowered.configurate.objectmapping;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import minimotd.org.spongepowered.configurate.objectmapping.FieldDiscoverer;
import minimotd.org.spongepowered.configurate.serialize.SerializationException;
import minimotd.org.spongepowered.configurate.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class RecordFieldDiscoverer
implements FieldDiscoverer<Object[]> {
    static final RecordFieldDiscoverer INSTANCE = new RecordFieldDiscoverer();

    private RecordFieldDiscoverer() {
    }

    @Override
    public <V> @Nullable FieldDiscoverer.InstanceFactory<@Nullable Object[]> discover(final AnnotatedType target, FieldDiscoverer.FieldCollector<@Nullable Object[], V> collector) throws SerializationException {
        Class clazz = GenericTypeReflector.erase((Type)target.getType());
        if (!clazz.isRecord()) {
            return null;
        }
        try {
            final RecordComponent[] recordComponents = clazz.getRecordComponents();
            final Class[] constructorParams = new Class[recordComponents.length];
            int i = 0;
            int recordComponentsLength = recordComponents.length;
            while (i < recordComponentsLength) {
                RecordComponent component = recordComponents[i];
                Method accessor = component.getAccessor();
                accessor.setAccessible(true);
                String name = component.getName();
                AnnotatedType genericType = component.getAnnotatedType();
                constructorParams[i] = GenericTypeReflector.erase((Type)genericType.getType());
                Field backingField = clazz.getDeclaredField(name);
                backingField.setAccessible(true);
                AnnotatedType resolvedType = GenericTypeReflector.resolveExactType((AnnotatedType)genericType, (AnnotatedType)target);
                AnnotatedElement annotationContainer = Types.combinedAnnotations(component, backingField, accessor);
                int targetIdx = i++;
                collector.accept(name, resolvedType, annotationContainer, (intermediate, el, implicitSupplier) -> {
                    intermediate[targetIdx] = el != null ? el : implicitSupplier.get();
                }, x$0 -> accessor.invoke(x$0, new Object[0]));
            }
            final Constructor clazzConstructor = clazz.getDeclaredConstructor(constructorParams);
            clazzConstructor.setAccessible(true);
            return new FieldDiscoverer.InstanceFactory<Object[]>(){

                @Override
                public Object[] begin() {
                    return new Object[recordComponents.length];
                }

                @Override
                public Object complete(@Nullable Object[] intermediate) throws SerializationException {
                    int length = intermediate.length;
                    for (int i = 0; i < length; ++i) {
                        if (intermediate[i] != null || !constructorParams[i].isPrimitive()) continue;
                        intermediate[i] = Types.defaultValue(constructorParams[i]);
                    }
                    try {
                        return clazzConstructor.newInstance(intermediate);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new SerializationException(target.getType(), (Throwable)e);
                    }
                }

                @Override
                public boolean canCreateInstances() {
                    return true;
                }
            };
        }
        catch (NoSuchFieldException | NoSuchMethodException ex) {
            throw new SerializationException(target.getType(), "Record class did not have fields and accessors aligning specification", (Throwable)ex);
        }
    }
}

