/*
 * Decompiled with CFR 0.152.
 */
package minimotd.org.spongepowered.configurate.hocon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import minimotd.org.spongepowered.configurate.CommentedConfigurationNode;
import minimotd.org.spongepowered.configurate.CommentedConfigurationNodeIntermediary;
import minimotd.org.spongepowered.configurate.ConfigurateException;
import minimotd.org.spongepowered.configurate.ConfigurationNode;
import minimotd.org.spongepowered.configurate.ConfigurationOptions;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.Config;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigException;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigFactory;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigList;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigObject;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigOrigin;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigOriginFactory;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigRenderOptions;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigValue;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigValueFactory;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.ConfigNodeComment;
import minimotd.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import minimotd.org.spongepowered.configurate.loader.CommentHandler;
import minimotd.org.spongepowered.configurate.loader.CommentHandlers;
import minimotd.org.spongepowered.configurate.loader.ParsingException;
import minimotd.org.spongepowered.configurate.util.UnmodifiableCollections;
import net.kyori.option.Option;
import net.kyori.option.OptionSchema;
import net.kyori.option.OptionState;

public final class HoconConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES;
    private static final ConfigRenderOptions DEFAULT_RENDER_OPTIONS;
    private static final ConfigOrigin CONFIGURATE_ORIGIN;
    private final ConfigRenderOptions render;
    private static final Constructor<? extends ConfigValue> CONFIG_OBJECT_CONSTRUCTOR;
    private static final Constructor<? extends ConfigValue> CONFIG_LIST_CONSTRUCTOR;

    public static Builder builder() {
        return new Builder();
    }

    private HoconConfigurationLoader(Builder build) {
        super(build, new CommentHandler[]{CommentHandlers.HASH, CommentHandlers.DOUBLE_SLASH});
        this.render = build.renderOptions();
    }

    @Override
    protected void checkCanWrite(ConfigurationNode node) throws ConfigurateException {
        if (!node.isMap() && !node.virtual() && node.raw() != null) {
            throw new ConfigurateException(node, "HOCON can only write nodes that are in map format!");
        }
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) throws ParsingException {
        Config hoconConfig;
        try {
            hoconConfig = ConfigFactory.parseReader(reader);
            hoconConfig = hoconConfig.resolve();
        }
        catch (ConfigException ex) {
            throw new ParsingException(node, ex.origin().lineNumber(), 0, ex.origin().description(), null, ex);
        }
        for (Map.Entry ent : hoconConfig.root().entrySet()) {
            HoconConfigurationLoader.readConfigValue((ConfigValue)ent.getValue(), (CommentedConfigurationNode)node.node(new Object[]{ent.getKey()}));
        }
    }

    private static void readConfigValue(ConfigValue value, CommentedConfigurationNode node) {
        if (!value.origin().comments().isEmpty()) {
            node.comment(value.origin().comments().stream().map(input -> {
                String lineStripped = input.commentText().replace("\r", "");
                if (!lineStripped.isEmpty() && lineStripped.charAt(0) == ' ') {
                    return lineStripped.substring(1);
                }
                return lineStripped;
            }).collect(Collectors.joining("\n")));
        }
        switch (value.valueType()) {
            case OBJECT: {
                ConfigObject object = (ConfigObject)value;
                if (object.isEmpty()) {
                    node.raw(Collections.emptyMap());
                    break;
                }
                for (Map.Entry ent : object.entrySet()) {
                    HoconConfigurationLoader.readConfigValue((ConfigValue)ent.getValue(), (CommentedConfigurationNode)node.node(new Object[]{ent.getKey()}));
                }
                break;
            }
            case LIST: {
                ConfigList list = (ConfigList)value;
                if (list.isEmpty()) {
                    node.raw(Collections.emptyList());
                    break;
                }
                for (int i = 0; i < list.size(); ++i) {
                    HoconConfigurationLoader.readConfigValue((ConfigValue)list.get(i), (CommentedConfigurationNode)node.node(new Object[]{i}));
                }
                break;
            }
            case NULL: {
                return;
            }
            default: {
                node.raw(value.unwrapped());
            }
        }
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) throws ConfigurateException {
        try {
            if (!node.isMap() && (node.virtual() || node.raw() == null)) {
                writer.write(SYSTEM_LINE_SEPARATOR);
                return;
            }
            ConfigValue value = HoconConfigurationLoader.fromValue(node);
            String renderedValue = value.render(this.render);
            writer.write(renderedValue);
        }
        catch (IOException io) {
            throw new ConfigurateException(node, (Throwable)io);
        }
    }

    private static ConfigValue fromValue(ConfigurationNode node) {
        CommentedConfigurationNodeIntermediary commentedNode;
        String origComment;
        ConfigValue ret;
        Object children;
        if (node.isMap()) {
            children = node.options().mapFactory().create();
            for (Map.Entry entry : node.childrenMap().entrySet()) {
                children.put(String.valueOf(entry.getKey()), HoconConfigurationLoader.fromValue((ConfigurationNode)entry.getValue()));
            }
            ret = HoconConfigurationLoader.newConfigObject((Map<String, ConfigValue>)children);
        } else if (node.isList()) {
            children = new ArrayList();
            for (ConfigurationNode configurationNode : node.childrenList()) {
                children.add(HoconConfigurationLoader.fromValue(configurationNode));
            }
            ret = HoconConfigurationLoader.newConfigList((List<ConfigValue>)children);
        } else {
            ret = ConfigValueFactory.fromAnyRef(node.rawScalar(), CONFIGURATE_ORIGIN.description());
        }
        if (node instanceof CommentedConfigurationNodeIntermediary && (origComment = (commentedNode = (CommentedConfigurationNodeIntermediary)node).comment()) != null) {
            ArrayList<ConfigNodeComment> arrayList = new ArrayList<ConfigNodeComment>();
            for (String line : CONFIGURATE_LINE_PATTERN.split(origComment, -1)) {
                if (line.length() != 0 && line.charAt(0) == '#') {
                    arrayList.add(ConfigNodeComment.hashComment(line));
                    continue;
                }
                arrayList.add(ConfigNodeComment.hashComment(' ' + line));
            }
            ret = ret.withOrigin(ret.origin().withComments(arrayList));
        }
        return ret;
    }

    static ConfigValue newConfigObject(Map<String, ConfigValue> vals) {
        try {
            return CONFIG_OBJECT_CONSTRUCTOR.newInstance(CONFIGURATE_ORIGIN, vals);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static ConfigValue newConfigList(List<ConfigValue> vals) {
        try {
            return CONFIG_LIST_CONSTRUCTOR.newInstance(CONFIGURATE_ORIGIN, vals);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root(options.nativeTypes(NATIVE_TYPES));
    }

    static {
        Class<ConfigValue> listClass;
        Class<ConfigValue> objectClass;
        NATIVE_TYPES = UnmodifiableCollections.toSet(Double.class, Long.class, Integer.class, Boolean.class, String.class, Number.class);
        DEFAULT_RENDER_OPTIONS = ConfigRenderOptions.defaults().setOriginComments(false).setJson(false);
        CONFIGURATE_ORIGIN = ConfigOriginFactory.newSimple("configurate-hocon");
        try {
            objectClass = Class.forName("minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.SimpleConfigObject").asSubclass(ConfigValue.class);
            listClass = Class.forName("minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.SimpleConfigList").asSubclass(ConfigValue.class);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            CONFIG_OBJECT_CONSTRUCTOR = objectClass.getDeclaredConstructor(ConfigOrigin.class, Map.class);
            CONFIG_OBJECT_CONSTRUCTOR.setAccessible(true);
            CONFIG_LIST_CONSTRUCTOR = listClass.getDeclaredConstructor(ConfigOrigin.class, List.class);
            CONFIG_LIST_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, HoconConfigurationLoader> {
        private static final OptionSchema.Mutable UNSAFE_SCHEMA = OptionSchema.childSchema((OptionSchema)AbstractConfigurationLoader.Builder.SCHEMA);
        public static final OptionSchema SCHEMA = UNSAFE_SCHEMA.frozenView();
        public static final Option<Boolean> PRETTY_PRINTING = UNSAFE_SCHEMA.booleanOption("hocon:pretty-printing", HoconConfigurationLoader.access$000().getFormatted());
        public static final Option<Integer> INDENT = UNSAFE_SCHEMA.intOption("hocon:indent", HoconConfigurationLoader.access$000().getIndent());
        public static final Option<Boolean> COMMENTS = UNSAFE_SCHEMA.booleanOption("hocon:emit-comments", HoconConfigurationLoader.access$000().getComments());
        public static final Option<Boolean> JSON_COMPATIBLE = UNSAFE_SCHEMA.booleanOption("hocon:json-compatible", HoconConfigurationLoader.access$000().getJson());

        @Override
        protected OptionSchema optionSchema() {
            return SCHEMA;
        }

        public Builder prettyPrinting(boolean prettyPrinting) {
            this.optionStateBuilder().value(PRETTY_PRINTING, (Object)prettyPrinting);
            return this;
        }

        public Builder indent(int indent) {
            this.optionStateBuilder().value(INDENT, (Object)indent);
            return this;
        }

        public Builder emitComments(boolean emitComments) {
            this.optionStateBuilder().value(COMMENTS, (Object)emitComments);
            return this;
        }

        public Builder emitJsonCompatible(boolean jsonCompatible) {
            this.optionStateBuilder().value(JSON_COMPATIBLE, (Object)jsonCompatible);
            return this;
        }

        ConfigRenderOptions renderOptions() {
            OptionState opt = this.optionState();
            return DEFAULT_RENDER_OPTIONS.setFormatted((Boolean)opt.value(PRETTY_PRINTING)).setIndent((Integer)opt.value(INDENT)).setComments((Boolean)opt.value(COMMENTS)).setJson((Boolean)opt.value(JSON_COMPATIBLE));
        }

        @Override
        public HoconConfigurationLoader build() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            return new HoconConfigurationLoader(this);
        }
    }
}

