/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common;

import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilderApplicable;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.LinearComponents;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jspecify.annotations.NullMarked;
import xyz.jpenilla.minimotd.common.Constants;
import xyz.jpenilla.minimotd.common.MiniMOTD;

@NullMarked
public final class CommandHandler {
    private final MiniMOTD<?> miniMOTD;

    public CommandHandler(MiniMOTD<?> miniMOTD) {
        this.miniMOTD = miniMOTD;
    }

    public void about(Audience audience) {
        Component header = CommandHandler.miniMessage("<gradient:white:#007FFF:white>                               ").decorate(TextDecoration.STRIKETHROUGH);
        Stream.of(header, ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().hoverEvent((HoverEventSource)CommandHandler.miniMessage("<rainbow>click me!"))).clickEvent(ClickEvent.openUrl((String)"https://github.com/jpenilla/MiniMOTD"))).content("MiniMOTD").color((TextColor)NamedTextColor.WHITE)).append((Component)Component.space())).append(CommandHandler.miniMessage("<gradient:#0047AB:#007FFF>2.2.1"))).build(), ((TextComponent.Builder)((TextComponent.Builder)Component.text().content("By ").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"jmp", (TextColor)NamedTextColor.WHITE))).build(), header).forEach(arg_0 -> ((Audience)audience).sendMessage(arg_0));
    }

    public void reload(Audience audience) {
        try {
            this.miniMOTD.reload();
        }
        catch (Exception ex) {
            this.miniMOTD.logger().warn("Failed to reload MiniMOTD. Ensure there are no errors in your config files.", (Throwable)ex);
            audience.sendMessage((Component)Component.textOfChildren((ComponentLike[])new ComponentLike[]{Constants.COMMAND_PREFIX, Component.space(), Component.text((String)"Failed to reload MiniMOTD. Ensure there are no errors in your config files. See console for more details.", (TextColor)NamedTextColor.RED)}));
            return;
        }
        audience.sendMessage((Component)Component.textOfChildren((ComponentLike[])new ComponentLike[]{Constants.COMMAND_PREFIX, Component.space(), Component.text((String)"Done reloading configuration.", (TextColor)NamedTextColor.GREEN)}));
    }

    public void help(Audience audience) {
        Stream.of(LinearComponents.linear((ComponentBuilderApplicable[])new ComponentBuilderApplicable[]{Constants.COMMAND_PREFIX, Component.space(), Component.text((String)"MiniMOTD command help", (TextColor)NamedTextColor.WHITE)}), CommandHandler.commandInfo("minimotd about", "Show information about MiniMOTD"), CommandHandler.commandInfo("minimotd reload", "Reload MiniMOTD configuration files"), CommandHandler.commandInfo("minimotd help", "Show this help menu")).forEach(arg_0 -> ((Audience)audience).sendMessage(arg_0));
    }

    private static Component commandInfo(String command, String description) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(" - ").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((char)'/', (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)command, (TextColor)TextColor.color((int)Short.MAX_VALUE)))).append((Component)Component.text((char)':'))).append((Component)Component.space())).append((Component)Component.text((String)description, (TextColor)NamedTextColor.WHITE))).hoverEvent((HoverEventSource)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Click to execute '").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)("/" + command), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"'"))).build())).clickEvent(ClickEvent.runCommand((String)("/" + command)))).build();
    }

    private static Component miniMessage(String message) {
        return MiniMessage.miniMessage().deserialize((Object)message);
    }

    @FunctionalInterface
    public static interface Executor {
        public void execute(Audience var1);
    }
}

