/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common.config;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import minimotd.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import minimotd.org.spongepowered.configurate.objectmapping.meta.Comment;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.minimotd.common.config.PostProcessor;

@ConfigSerializable
public final class PluginSettings {
    @Comment(value="Do you want the plugin to check for updates on GitHub at launch?\nhttps://github.com/jpenilla/MiniMOTD")
    private boolean updateChecker = true;
    @Comment(value="Settings only applicable when running the plugin on a proxy (Velocity or Waterfall/Bungeecord)")
    private ProxySettings proxySettings = new ProxySettings();

    public @NonNull ProxySettings proxySettings() {
        return this.proxySettings;
    }

    public boolean updateChecker() {
        return this.updateChecker;
    }

    @PostProcessor
    private void processVirtualHosts() {
        this.proxySettings.processVirtualHosts();
    }

    @ConfigSerializable
    public static final class ProxySettings {
        @Comment(value="Here you can assign configs in the 'extra-configs' folder to specific virtual hosts\nEither use the name of the config in 'extra-configs', or use \"default\" to use the configuration in main.conf\n\nFormat is \"hostname:port\"=\"configName|default\"\nParts of domains can be substituted for wildcards, i.e. \"*.mydomain.com:25565\". Wildcard-containing configs are\nchecked in the order they are declared if there are no exact matches.")
        private final Map<String, String> virtualHostConfigs = new LinkedHashMap<String, String>();
        private transient @Nullable Map<String[], String> splitVirtualHostConfigs;
        @Comment(value="Set whether to enable virtual host testing mode.\nWhen enabled, MiniMOTD will print virtual host debug info to the console on each server ping.")
        private boolean virtualHostTestMode = false;

        public ProxySettings() {
            this.virtualHostConfigs.put("minigames.example.com:25565", "default");
            this.virtualHostConfigs.put("survival.example.com:25565", "survival");
            this.virtualHostConfigs.put("skyblock.example.com:25565", "skyblock");
        }

        public ProxySettings(Map<String, String> virtualHostConfigs) {
            this.virtualHostConfigs.putAll(virtualHostConfigs);
        }

        public boolean virtualHostTestMode() {
            return this.virtualHostTestMode;
        }

        public @Nullable String findConfigStringForHost(@NonNull String host, int port) {
            Objects.requireNonNull(this.splitVirtualHostConfigs, "processVirtualHosts must be called first");
            host = ProxySettings.processTcpShieldHostname(host).toLowerCase(Locale.ENGLISH) + ':' + port;
            @Nullable String exactMatch = this.virtualHostConfigs.get(host);
            if (exactMatch != null) {
                return exactMatch;
            }
            if (this.splitVirtualHostConfigs.isEmpty()) {
                return null;
            }
            String[] splitHost = host.split("\\.");
            block0: for (Map.Entry<String[], String> e : this.splitVirtualHostConfigs.entrySet()) {
                String[] splitKey = e.getKey();
                if (splitKey.length != splitHost.length) continue;
                for (int i = 0; i < splitHost.length; ++i) {
                    String keyPart = splitKey[i];
                    if (!keyPart.equals(splitHost[i]) && !keyPart.equals("*")) continue block0;
                }
                return e.getValue();
            }
            return null;
        }

        private static String processTcpShieldHostname(String hostname) {
            String[] split;
            if (hostname.contains("///") && (split = hostname.split("///")).length == 4) {
                return split[0];
            }
            return hostname;
        }

        public void processVirtualHosts() {
            LinkedHashMap<String, String> virtualHosts = new LinkedHashMap<String, String>(this.virtualHostConfigs);
            this.virtualHostConfigs.clear();
            virtualHosts.forEach((host, config) -> this.virtualHostConfigs.put(host.toLowerCase(Locale.ENGLISH), (String)config));
            this.splitVirtualHostConfigs = new LinkedHashMap<String[], String>();
            this.virtualHostConfigs.forEach((host, config) -> {
                if (!host.contains("*")) {
                    return;
                }
                this.splitVirtualHostConfigs.put(host.split("\\."), (String)config);
            });
        }
    }
}

