/*
 * Decompiled with CFR 0.152.
 */
package minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.ConfigValueType;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.AbstractConfigObject;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.AbstractConfigValue;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.ConfigBoolean;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.ConfigDouble;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.ConfigLong;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.ConfigNull;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.ConfigString;
import minimotd.org.spongepowered.configurate.hocon.internal.typesafeconfig.impl.SimpleConfigList;

final class DefaultTransformer {
    DefaultTransformer() {
    }

    static AbstractConfigValue transform(AbstractConfigValue value, ConfigValueType requested) {
        if (value.valueType() == ConfigValueType.STRING) {
            String s = (String)value.unwrapped();
            switch (requested) {
                case NUMBER: {
                    try {
                        Long v = Long.parseLong(s);
                        return new ConfigLong(value.origin(), v, s);
                    }
                    catch (NumberFormatException v) {
                        try {
                            Double v2 = Double.parseDouble(s);
                            return new ConfigDouble(value.origin(), v2, s);
                        }
                        catch (NumberFormatException v2) {
                            break;
                        }
                    }
                }
                case NULL: {
                    if (!s.equals("null")) break;
                    return new ConfigNull(value.origin());
                }
                case BOOLEAN: {
                    if (s.equals("true") || s.equals("yes") || s.equals("on")) {
                        return new ConfigBoolean(value.origin(), true);
                    }
                    if (!s.equals("false") && !s.equals("no") && !s.equals("off")) break;
                    return new ConfigBoolean(value.origin(), false);
                }
                case LIST: {
                    break;
                }
                case OBJECT: {
                    break;
                }
            }
        } else if (requested == ConfigValueType.STRING) {
            switch (value.valueType()) {
                case NUMBER: 
                case BOOLEAN: {
                    return new ConfigString.Quoted(value.origin(), value.transformToString());
                }
                case NULL: {
                    break;
                }
                case OBJECT: {
                    break;
                }
                case LIST: {
                    break;
                }
            }
        } else if (requested == ConfigValueType.LIST && value.valueType() == ConfigValueType.OBJECT) {
            AbstractConfigObject o = (AbstractConfigObject)value;
            TreeMap<Integer, AbstractConfigValue> values = new TreeMap<Integer, AbstractConfigValue>();
            for (String key : o.keySet()) {
                try {
                    int i = Integer.parseInt(key, 10);
                    if (i < 0) continue;
                    values.put(i, o.get(key));
                }
                catch (NumberFormatException e) {}
            }
            if (!values.isEmpty()) {
                ArrayList<AbstractConfigValue> list = new ArrayList<AbstractConfigValue>();
                for (Map.Entry entry : values.entrySet()) {
                    list.add((AbstractConfigValue)entry.getValue());
                }
                return new SimpleConfigList(value.origin(), list);
            }
        }
        return value;
    }
}

