/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.velocity;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.util.Favicon;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.Set;
import minimotd.org.bstats.velocity.Metrics;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import xyz.jpenilla.minimotd.common.CommandHandler;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.MiniMOTDPlatform;
import xyz.jpenilla.minimotd.common.util.BrigadierUtil;
import xyz.jpenilla.minimotd.common.util.UpdateChecker;
import xyz.jpenilla.minimotd.velocity.PingListener;

public final class MiniMOTDVelocity
implements MiniMOTDPlatform<Favicon> {
    private static final Set<Class<?>> LISTENER_CLASSES = ImmutableSet.of(PingListener.class);
    private final MiniMOTD<Favicon> miniMOTD;
    private final ProxyServer server;
    private final Logger logger;
    private final CommandManager commandManager;
    private final Path dataDirectory;
    private final Metrics.Factory metricsFactory;
    private final Injector injector;

    @Inject
    public MiniMOTDVelocity(@NonNull ProxyServer server, @NonNull Logger logger, @NonNull CommandManager commandManager, @DataDirectory @NonNull Path dataDirectory,  @NonNull Metrics.Factory metricsFactory, @NonNull Injector injector) {
        this.server = server;
        this.logger = logger;
        this.commandManager = commandManager;
        this.dataDirectory = dataDirectory;
        this.metricsFactory = metricsFactory;
        this.miniMOTD = new MiniMOTD<Favicon>(this);
        this.miniMOTD.configManager().loadExtraConfigs();
        this.injector = injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<MiniMOTD<Favicon>>(){}).toInstance((Object)MiniMOTDVelocity.this.miniMOTD);
            }
        }});
    }

    @Subscribe
    public void onProxyInitialization(@NonNull ProxyInitializeEvent event) {
        for (Class<?> clazz : LISTENER_CLASSES) {
            this.server.getEventManager().register((Object)this, this.injector.getInstance(clazz));
        }
        this.registerCommand();
        this.metricsFactory.make(this, 10257);
        if (this.miniMOTD.configManager().pluginSettings().updateChecker()) {
            this.server.getScheduler().buildTask((Object)this, () -> new UpdateChecker().checkVersion().forEach(arg_0 -> ((Logger)this.logger).info(arg_0))).schedule();
        }
    }

    private void registerCommand() {
        this.commandManager.register(this.commandManager.metaBuilder("minimotd").plugin((Object)this).build(), (Command)new BrigadierCommand(BrigadierUtil.buildTree(new CommandHandler(this.miniMOTD), source -> source, source -> source.hasPermission("minimotd.admin"))));
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.dataDirectory;
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    @Override
    public @NonNull Favicon loadIcon(@NonNull BufferedImage image) {
        return Favicon.create((BufferedImage)image);
    }

    @Override
    public void onReload() {
        this.miniMOTD.configManager().loadExtraConfigs();
    }
}

