/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.api.util.Favicon;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.common.config.MOTDConfig;

@NullMarked
public final class PingListener {
    private final MiniMOTD<Favicon> miniMOTD;
    private final ProxyServer proxy;

    @Inject
    private PingListener(MiniMOTD<Favicon> miniMOTD, ProxyServer proxy) {
        this.miniMOTD = miniMOTD;
        this.proxy = proxy;
    }

    @Subscribe
    public EventTask onProxyPingEvent(ProxyPingEvent event) {
        return EventTask.async(() -> this.handle(event));
    }

    private void handle(ProxyPingEvent event) {
        MOTDConfig config = this.miniMOTD.configManager().resolveConfig((InetSocketAddress)event.getConnection().getVirtualHost().orElse(null));
        ServerPing.Builder pong = event.getPing().asBuilder();
        List<String> targetServers = config.targetServers();
        int playersCount = 0;
        if (targetServers.isEmpty()) {
            playersCount = pong.getOnlinePlayers();
        } else {
            HashSet players = new HashSet();
            for (String serverName : targetServers) {
                @Nullable RegisteredServer server = this.proxy.getServer(serverName).orElse(null);
                if (server == null) continue;
                playersCount += server.getPlayersConnected().size();
                players.addAll(server.getPlayersConnected().stream().map(p -> new ServerPing.SamplePlayer(p.getGameProfile().getName(), p.getUniqueId())).collect(Collectors.toList()));
            }
            pong.clearSamplePlayers();
            pong.samplePlayers(players.toArray(new ServerPing.SamplePlayer[0]));
        }
        PingResponse<Favicon> response = this.miniMOTD.createMOTD(config, playersCount, pong.getMaximumPlayers());
        response.icon(arg_0 -> ((ServerPing.Builder)pong).favicon(arg_0));
        response.motd(arg_0 -> ((ServerPing.Builder)pong).description(arg_0));
        response.playerCount().applyCount(arg_0 -> ((ServerPing.Builder)pong).onlinePlayers(arg_0), arg_0 -> ((ServerPing.Builder)pong).maximumPlayers(arg_0));
        if (response.disablePlayerListHover()) {
            pong.clearSamplePlayers();
        }
        if (response.hidePlayerCount()) {
            pong.nullPlayers();
        }
        event.setPing(pong.build());
    }
}

