/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.minimotd.common.MiniMOTD;

public final class IconManager<I> {
    private final Map<String, I> icons = new ConcurrentHashMap<String, I>();
    private final MiniMOTD<I> miniMOTD;
    private final Path iconsDirectory;

    public IconManager(@NonNull MiniMOTD<I> miniMOTD) {
        this.miniMOTD = miniMOTD;
        this.iconsDirectory = miniMOTD.dataDirectory().resolve("icons");
        this.loadIcons();
    }

    public void loadIcons() {
        this.icons.clear();
        try {
            if (!Files.exists(this.iconsDirectory, new LinkOption[0])) {
                Files.createDirectories(this.iconsDirectory, new FileAttribute[0]);
            }
            try (Stream<Path> stream = Files.list(this.iconsDirectory);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.getFileName().toString().endsWith(".png")).forEach(this::loadIcon);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception loading server icons", ex);
        }
    }

    private void loadIcon(@NonNull Path iconFile) {
        try (InputStream inputStream = Files.newInputStream(iconFile, new OpenOption[0]);){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage.getHeight() == 64 && bufferedImage.getWidth() == 64) {
                I newIcon = this.miniMOTD.platform().loadIcon(bufferedImage);
                this.icons.put(iconFile.getFileName().toString().split("\\.")[0], newIcon);
            } else {
                this.miniMOTD.logger().warn("Could not load {}: image must be 64x64px", (Object)iconFile.getFileName());
            }
        }
        catch (Exception ex) {
            this.miniMOTD.logger().warn("Could not load {}: invalid image file", (Object)iconFile.getFileName(), (Object)ex);
        }
    }

    public @Nullable I icon(@Nullable String iconString) {
        if (this.icons.isEmpty()) {
            return null;
        }
        if (iconString == null || "random".equals(iconString)) {
            int randomIndex = ThreadLocalRandom.current().nextInt(this.icons.size());
            Iterator<I> iterator = this.icons.values().iterator();
            for (int i = 0; i < randomIndex; ++i) {
                iterator.next();
            }
            return iterator.next();
        }
        return this.icons.get(iconString);
    }
}

