/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common.config;

import java.lang.reflect.Type;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import minimotd.org.spongepowered.configurate.serialize.ScalarSerializer;
import minimotd.org.spongepowered.configurate.serialize.SerializationException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.minimotd.common.util.Int2IntFunction;

public final class PlayerCountModifier
implements Int2IntFunction {
    private final String input;
    private final Int2IntFunction function;

    private PlayerCountModifier(@NonNull String input, @NonNull Int2IntFunction function) {
        this.input = input;
        this.function = function;
    }

    @Override
    public int apply(int actualPlayers) {
        return this.function.apply(actualPlayers);
    }

    public @NonNull String input() {
        return this.input;
    }

    public static @NonNull PlayerCountModifier parse(@NonNull String input) {
        try {
            if (input.contains(":")) {
                return PlayerCountModifier.parseRandomModifier(input);
            }
            if (input.contains("%")) {
                return PlayerCountModifier.parsePercentModifier(input);
            }
            if (input.contains("=")) {
                return PlayerCountModifier.parseConstantModifier(input);
            }
            if (input.contains("+")) {
                return PlayerCountModifier.parseMinimumModifier(input);
            }
            return PlayerCountModifier.parseAddModifier(input);
        }
        catch (NumberFormatException ex) {
            throw PlayerCountModifier.cannotParse(input, ex);
        }
    }

    private static @NonNull PlayerCountModifier parseRandomModifier(@NonNull String input) {
        String[] fakePlayers = input.split(":");
        if (fakePlayers.length != 2) {
            throw PlayerCountModifier.cannotParse(input, null);
        }
        int start = Integer.parseInt(fakePlayers[0]);
        int end = Integer.parseInt(fakePlayers[1]);
        return new PlayerCountModifier(input, actual -> actual + ThreadLocalRandom.current().nextInt(start, end));
    }

    private static @NonNull PlayerCountModifier parsePercentModifier(@NonNull String input) {
        double factor = 1.0 + Double.parseDouble(input.replace("%", "")) / 100.0;
        return new PlayerCountModifier(input, actual -> (int)Math.ceil(factor * (double)actual));
    }

    private static @NonNull PlayerCountModifier parseConstantModifier(@NonNull String input) {
        int value = Integer.parseInt(input.replace("=", ""));
        return new PlayerCountModifier(input, actual -> value);
    }

    private static @NonNull PlayerCountModifier parseMinimumModifier(@NonNull String input) {
        int minPlayers = Integer.parseInt(input.replace("+", ""));
        return new PlayerCountModifier(input, actual -> Math.max(minPlayers, actual));
    }

    private static @NonNull PlayerCountModifier parseAddModifier(@NonNull String input) {
        int addedPlayers = Integer.parseInt(input);
        return new PlayerCountModifier(input, actual -> actual + addedPlayers);
    }

    private static @NonNull IllegalArgumentException cannotParse(@NonNull String input, @Nullable Throwable cause) {
        return new IllegalArgumentException(String.format("Unable to parse a player count modifier from input string '%s'.", input), cause);
    }

    public static @NonNull Serializer serializer() {
        return Serializer.INSTANCE;
    }

    public static final class Serializer
    extends ScalarSerializer<PlayerCountModifier> {
        private static final Serializer INSTANCE = new Serializer();

        private Serializer() {
            super(PlayerCountModifier.class);
        }

        @Override
        public PlayerCountModifier deserialize(@NonNull Type type, @NonNull Object obj) throws SerializationException {
            try {
                return PlayerCountModifier.parse(obj.toString());
            }
            catch (IllegalArgumentException ex) {
                throw new SerializationException(ex);
            }
        }

        @Override
        protected Object serialize(@NonNull PlayerCountModifier item, @NonNull Predicate<Class<?>> typeSupported) {
            return item.input();
        }
    }
}

