/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.bukkit;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import minimotd.net.kyori.adventure.audience.Audience;
import minimotd.net.kyori.adventure.text.Component;
import minimotd.net.kyori.adventure.text.TextComponent;
import minimotd.net.kyori.adventure.text.event.ClickEvent;
import minimotd.net.kyori.adventure.text.event.HoverEventSource;
import minimotd.net.kyori.adventure.text.format.NamedTextColor;
import minimotd.net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jspecify.annotations.NonNull;
import xyz.jpenilla.minimotd.bukkit.MiniMOTDBukkit;
import xyz.jpenilla.minimotd.common.CommandHandler;

final class BukkitCommand
implements CommandExecutor,
TabCompleter {
    private final MiniMOTDBukkit plugin;
    private final CommandHandler handler;
    private static final List<String> COMMANDS = ImmutableList.of((Object)"about", (Object)"reload", (Object)"help");

    BukkitCommand(@NonNull MiniMOTDBukkit plugin) {
        this.plugin = plugin;
        this.handler = new CommandHandler(plugin.miniMOTD());
    }

    public boolean onCommand(@NonNull CommandSender sender, @NonNull Command command, @NonNull String label, @NonNull String[] args) {
        Audience audience = this.plugin.audiences().sender(sender);
        if (!sender.hasPermission("minimotd.admin")) {
            audience.sendMessage(Component.text("No permission.", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            this.onInvalidUse(audience);
            return true;
        }
        switch (args[0]) {
            case "about": {
                this.handler.about(audience);
                return true;
            }
            case "help": {
                this.handler.help(audience);
                return true;
            }
            case "reload": {
                this.handler.reload(audience);
                return true;
            }
        }
        this.onInvalidUse(audience);
        return true;
    }

    private void onInvalidUse(@NonNull Audience audience) {
        audience.sendMessage(((TextComponent)Component.text("Invalid command usage. Use '/minimotd help' for a list of command provided by MiniMOTD.", (TextColor)NamedTextColor.RED).hoverEvent((HoverEventSource)Component.text("Click to execute '/minimotd help'"))).clickEvent(ClickEvent.runCommand("/minimotd help")));
    }

    public List<String> onTabComplete(@NonNull CommandSender sender, @NonNull Command command, @NonNull String alias, @NonNull String[] args) {
        if (args.length < 2 && sender.hasPermission("minimotd.admin")) {
            return COMMANDS;
        }
        return Collections.emptyList();
    }
}

