/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.bukkit;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import minimotd.io.papermc.lib.PaperLib;
import minimotd.net.kyori.adventure.platform.bukkit.BukkitAudiences;
import minimotd.org.bstats.bukkit.Metrics;
import minimotd.org.bstats.charts.SimplePie;
import minimotd.org.slf4j.Logger;
import minimotd.org.slf4j.LoggerFactory;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.CachedServerIcon;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.minimotd.bukkit.BukkitCommand;
import xyz.jpenilla.minimotd.bukkit.PaperPingListener;
import xyz.jpenilla.minimotd.bukkit.PingListener;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.MiniMOTDPlatform;
import xyz.jpenilla.minimotd.common.util.Nag;
import xyz.jpenilla.minimotd.common.util.UpdateChecker;

public final class MiniMOTDBukkit
extends JavaPlugin
implements MiniMOTDPlatform<CachedServerIcon> {
    private static final boolean PAPER_PING_EVENT_EXISTS = MiniMOTDBukkit.findClass("com.destroystokyo.paper.event.server.PaperServerListPingEvent") != null;
    private Logger logger;
    private MiniMOTD<CachedServerIcon> miniMOTD;
    private BukkitAudiences audiences;

    public void onEnable() {
        this.logger = LoggerFactory.getLogger(this.getName());
        if (PaperLib.getMinecraftVersion() > 21 || PaperLib.getMinecraftVersion() == 21 && PaperLib.getMinecraftPatchVersion() > 7) {
            new Nag.Slf4J(this.logger).lines("You are using the incorrect MiniMOTD build for your server software.", "This build is for Spigot/Paper 1.8.8 through 1.21.7.", "Builds for Paper 1.21.8+ are available on Modrinth (https://modrinth.com/plugin/minimotd)", "and Hangar (https://hangar.papermc.io/jmp/MiniMOTD).", "When downloading be sure to check the supported versions/platforms", "field on the versions page, and/or make the correct selections in", "the download menu.").error(true).logBanner();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.miniMOTD = new MiniMOTD<CachedServerIcon>(this);
        this.audiences = BukkitAudiences.create((Plugin)this);
        if (PAPER_PING_EVENT_EXISTS) {
            this.getServer().getPluginManager().registerEvents((Listener)new PaperPingListener(this.miniMOTD), (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new PingListener(this.miniMOTD), (Plugin)this);
            if (PaperLib.getMinecraftVersion() >= 12) {
                this.suggestPaper();
            }
        }
        PluginCommand command = this.getCommand("minimotd");
        if (command != null) {
            BukkitCommand bukkitCommand = new BukkitCommand(this);
            command.setExecutor((CommandExecutor)bukkitCommand);
            command.setTabCompleter((TabCompleter)bukkitCommand);
        }
        Metrics metrics = new Metrics((Plugin)this, 8132);
        metrics.addCustomChart(new SimplePie("variant", () -> "bukkit"));
        if (this.miniMOTD.configManager().pluginSettings().updateChecker()) {
            try {
                Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
                CompletableFuture.runAsync(() -> new UpdateChecker().checkVersion().forEach(this.logger::info)).whenComplete(($, thr) -> {
                    if (thr != null) {
                        this.logger.warn("Exception checking for updates", (Throwable)thr);
                    }
                });
            }
            catch (ReflectiveOperationException ex) {
                this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, () -> new UpdateChecker().checkVersion().forEach(this.logger::info));
            }
        }
    }

    public @NonNull MiniMOTD<CachedServerIcon> miniMOTD() {
        return this.miniMOTD;
    }

    @Override
    public @NonNull Path dataDirectory() {
        return this.getDataFolder().toPath();
    }

    @Override
    public @NonNull Logger logger() {
        return this.logger;
    }

    @Override
    public @NonNull CachedServerIcon loadIcon(@NonNull BufferedImage image) throws Exception {
        return this.getServer().loadServerIcon(image);
    }

    public @NonNull BukkitAudiences audiences() {
        return this.audiences;
    }

    private void suggestPaper() {
        this.logger.warn("======================================================");
        this.logger.warn(" MiniMOTD works better if you use Paper as your server");
        this.logger.warn(" software.");
        this.logger.warn(" ");
        this.logger.warn(" Spigot does not include the necessary APIs for all");
        this.logger.warn(" of MiniMOTD's features to operate. MiniMOTD was");
        this.logger.warn(" designed to work with Paper and it's expanded API");
        this.logger.warn(" for full compatibility.");
        this.logger.warn(" ");
        this.logger.warn(" Get Paper from https://papermc.io/downloads");
        this.logger.warn("======================================================");
    }

    private static @Nullable Class<?> findClass(@NonNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

