/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.bukkit;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import minimotd.io.papermc.lib.PaperLib;
import minimotd.net.kyori.adventure.text.Component;
import minimotd.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.util.CachedServerIcon;
import org.jspecify.annotations.NonNull;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.common.config.MOTDConfig;

public final class PaperPingListener
implements Listener {
    private static final Method WORK_AROUND_PAPER_BUG;
    private final LegacyComponentSerializer unusualHexSerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private final MiniMOTD<CachedServerIcon> miniMOTD;

    PaperPingListener(@NonNull MiniMOTD<CachedServerIcon> miniMOTD) {
        this.miniMOTD = miniMOTD;
    }

    @EventHandler
    public void handlePing(@NonNull PaperServerListPingEvent event) {
        MOTDConfig cfg = this.miniMOTD.configManager().mainConfig();
        PingResponse<CachedServerIcon> response = this.miniMOTD.createMOTD(cfg, event.getNumPlayers(), event.getMaxPlayers());
        response.playerCount().applyCount(arg_0 -> ((PaperServerListPingEvent)event).setNumPlayers(arg_0), arg_0 -> ((PaperServerListPingEvent)event).setMaxPlayers(arg_0));
        response.motd(motd -> {
            if (event.getClient().getProtocolVersion() < 735 || PaperLib.getMinecraftVersion() < 16) {
                event.setMotd(LegacyComponentSerializer.legacySection().serialize((Component)motd));
            } else {
                event.setMotd(this.unusualHexSerializer.serialize((Component)motd));
            }
        });
        response.icon(arg_0 -> ((PaperServerListPingEvent)event).setServerIcon(arg_0));
        if (response.disablePlayerListHover()) {
            if (WORK_AROUND_PAPER_BUG != null) {
                try {
                    ((List)WORK_AROUND_PAPER_BUG.invoke((Object)event, new Object[0])).clear();
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to invoke " + WORK_AROUND_PAPER_BUG.getName(), e);
                }
            } else {
                event.getPlayerSample().clear();
            }
        }
        if (response.hidePlayerCount()) {
            event.setHidePlayers(true);
        }
    }

    static {
        Method paperWorkaround;
        try {
            paperWorkaround = PaperServerListPingEvent.class.getMethod("getListedPlayers", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            paperWorkaround = null;
        }
        WORK_AROUND_PAPER_BUG = paperWorkaround;
    }
}

