/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.bukkit;

import minimotd.io.papermc.lib.PaperLib;
import minimotd.net.kyori.adventure.text.Component;
import minimotd.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import org.jspecify.annotations.NonNull;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.common.config.MOTDConfig;

public final class PingListener
implements Listener {
    private final MiniMOTD<CachedServerIcon> miniMOTD;
    private final LegacyComponentSerializer unusualHexSerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    PingListener(@NonNull MiniMOTD<CachedServerIcon> miniMOTD) {
        this.miniMOTD = miniMOTD;
    }

    @EventHandler
    public void handlePing(@NonNull ServerListPingEvent event) {
        MOTDConfig cfg = this.miniMOTD.configManager().mainConfig();
        PingResponse<CachedServerIcon> response = this.miniMOTD.createMOTD(cfg, event.getNumPlayers(), event.getMaxPlayers());
        event.setMaxPlayers(response.playerCount().maxPlayers());
        response.motd(motd -> {
            if (PaperLib.getMinecraftVersion() > 15) {
                event.setMotd(this.unusualHexSerializer.serialize((Component)motd));
            } else {
                event.setMotd(LegacyComponentSerializer.legacySection().serialize((Component)motd));
            }
        });
        response.icon(icon -> {
            try {
                event.setServerIcon(icon);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
    }
}

