/*
 * Decompiled with CFR 0.152.
 */
package minimotd.net.kyori.adventure.text.serializer.spongeapi;

import java.util.Objects;
import minimotd.net.kyori.adventure.text.Component;
import minimotd.net.kyori.adventure.text.serializer.ComponentSerializer;
import minimotd.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import minimotd.net.kyori.adventure.text.serializer.gson.legacyimpl.NBTLegacyHoverEventSerializer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public final class SpongeComponentSerializer
implements ComponentSerializer<Component, Component, Text> {
    private static final SpongeComponentSerializer INSTANCE = new SpongeComponentSerializer();
    private static final GsonComponentSerializer LEGACY_GSON_SERIALIZER = GsonComponentSerializer.builder().downsampleColors().emitLegacyHoverEvent().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).build();

    @NotNull
    public static SpongeComponentSerializer get() {
        return INSTANCE;
    }

    private SpongeComponentSerializer() {
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Text input) {
        return LEGACY_GSON_SERIALIZER.deserialize(TextSerializers.JSON.serialize(Objects.requireNonNull(input, "text")));
    }

    @Override
    @NotNull
    public Text serialize(@NotNull Component component) {
        return TextSerializers.JSON.deserialize((String)LEGACY_GSON_SERIALIZER.serialize(Objects.requireNonNull(component, "component")));
    }
}

