/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.common.config;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import minimotd.org.spongepowered.configurate.ConfigurateException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.config.ConfigLoader;
import xyz.jpenilla.minimotd.common.config.MOTDConfig;
import xyz.jpenilla.minimotd.common.config.PluginSettings;
import xyz.jpenilla.minimotd.common.util.Pair;

public final class ConfigManager {
    private final MiniMOTD<?> miniMOTD;
    private final ConfigLoader<MOTDConfig> mainConfigLoader;
    private MOTDConfig mainConfig;
    private final ConfigLoader<PluginSettings> pluginSettingsLoader;
    private PluginSettings pluginSettings;
    private final Map<String, MOTDConfig> extraConfigs = new HashMap<String, MOTDConfig>();

    public ConfigManager(@NonNull MiniMOTD<?> miniMOTD) {
        this.miniMOTD = miniMOTD;
        this.mainConfigLoader = new ConfigLoader<MOTDConfig>(MOTDConfig.class, this.miniMOTD.dataDirectory().resolve("main.conf"), options -> options.header("MiniMOTD Main Configuration"));
        this.pluginSettingsLoader = new ConfigLoader<PluginSettings>(PluginSettings.class, this.miniMOTD.dataDirectory().resolve("plugin_settings.conf"), options -> options.header("MiniMOTD Plugin Configuration"));
    }

    public void loadConfigs() {
        try {
            this.mainConfig = this.mainConfigLoader.load();
            this.mainConfigLoader.save(this.mainConfig);
            this.pluginSettings = this.pluginSettingsLoader.load();
            this.pluginSettingsLoader.save(this.pluginSettings);
        }
        catch (ConfigurateException e) {
            throw new IllegalStateException("Failed to load config", e);
        }
    }

    public void loadExtraConfigs() {
        this.extraConfigs.clear();
        Path extraConfigsDir = this.miniMOTD.dataDirectory().resolve("extra-configs");
        try {
            if (!Files.exists(extraConfigsDir, new LinkOption[0])) {
                Files.createDirectories(extraConfigsDir, new FileAttribute[0]);
                this.createDefaultExtraConfigs(extraConfigsDir);
            }
            try (Stream<Path> stream = Files.list(extraConfigsDir);){
                for (Path path : stream.collect(Collectors.toList())) {
                    if (!path.toString().endsWith(".conf")) continue;
                    String name = path.getFileName().toString().replace(".conf", "");
                    ConfigLoader<MOTDConfig> loader = new ConfigLoader<MOTDConfig>(MOTDConfig.class, path, options -> options.header(String.format("Extra MiniMOTD config '%s'", name)));
                    MOTDConfig config = loader.load();
                    loader.save(config);
                    this.extraConfigs.put(name, config);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load virtual host configs", e);
        }
    }

    private void createDefaultExtraConfigs(@NonNull Path extraConfigsDir) throws ConfigurateException {
        List<Pair> defaults = Collections.unmodifiableList(Arrays.asList(Pair.pair(extraConfigsDir.resolve("skyblock.conf"), new MOTDConfig.MOTD("<green><italic>Skyblock</green>", "<bold><rainbow>MiniMOTD Skyblock Server")), Pair.pair(extraConfigsDir.resolve("survival.conf"), new MOTDConfig.MOTD("<gradient:blue:red>Survival Mode Hardcore", "<green><bold>MiniMOTD Survival Server"))));
        for (Pair pair : defaults) {
            ConfigLoader<MOTDConfig> loader = new ConfigLoader<MOTDConfig>(MOTDConfig.class, (Path)pair.left());
            loader.save(new MOTDConfig((MOTDConfig.MOTD)pair.right()));
        }
    }

    public @NonNull MOTDConfig mainConfig() {
        if (this.mainConfig == null) {
            throw new IllegalStateException("Config has not yet been loaded");
        }
        return this.mainConfig;
    }

    public @NonNull PluginSettings pluginSettings() {
        if (this.pluginSettings == null) {
            throw new IllegalStateException("Config has not yet been loaded");
        }
        return this.pluginSettings;
    }

    public @NonNull MOTDConfig resolveConfig(@Nullable InetSocketAddress address) {
        if (address == null) {
            return this.mainConfig();
        }
        String configString = this.pluginSettings().proxySettings().findConfigStringForHost(address.getHostString(), address.getPort());
        if (this.pluginSettings().proxySettings().virtualHostTestMode()) {
            this.miniMOTD.platform().logger().info("[virtual-host-debug] Virtual Host: '{}:{}', Selected Config: '{}'", new Object[]{address.getHostString(), address.getPort(), configString == null ? "default" : configString});
        }
        if (configString == null) {
            return this.mainConfig();
        }
        return this.resolveConfig(configString);
    }

    public @NonNull MOTDConfig resolveConfig(@NonNull String name) {
        if ("default".equals(name)) {
            return this.mainConfig();
        }
        MOTDConfig cfg = this.extraConfigs.get(name);
        if (cfg != null) {
            return cfg;
        }
        this.miniMOTD.logger().warn("Invalid extra-config name: '{}', falling back to main.conf", (Object)name);
        return this.mainConfig();
    }
}

