/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.minimotd.sponge7;

import com.google.inject.Inject;
import minimotd.net.kyori.adventure.text.Component;
import minimotd.net.kyori.adventure.text.serializer.spongeapi.SpongeComponentSerializer;
import org.jspecify.annotations.NonNull;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.Favicon;
import xyz.jpenilla.minimotd.common.MiniMOTD;
import xyz.jpenilla.minimotd.common.PingResponse;
import xyz.jpenilla.minimotd.common.config.MOTDConfig;

final class ClientPingServerEventListener
implements EventListener<ClientPingServerEvent> {
    private final MiniMOTD<Favicon> miniMOTD;

    @Inject
    private ClientPingServerEventListener(@NonNull MiniMOTD<Favicon> miniMOTD) {
        this.miniMOTD = miniMOTD;
    }

    public void handle(@NonNull ClientPingServerEvent event) {
        ClientPingServerEvent.Response.Players players;
        ClientPingServerEvent.Response response = event.getResponse();
        ClientPingServerEvent.Response.Players players0 = response.getPlayers().orElse(null);
        if (players0 != null) {
            players = players0;
        } else {
            response.setHidePlayers(false);
            players = response.getPlayers().orElse(null);
            if (players == null) {
                this.miniMOTD.logger().warn(String.format("Failed to handle ClientPingServerEvent: '%s', response.getPlayers() was null.", event));
                return;
            }
        }
        MOTDConfig config = this.miniMOTD.configManager().mainConfig();
        PingResponse<Favicon> mini = this.miniMOTD.createMOTD(config, players.getOnline(), players.getMax());
        mini.playerCount().applyCount(arg_0 -> ((ClientPingServerEvent.Response.Players)players).setOnline(arg_0), arg_0 -> ((ClientPingServerEvent.Response.Players)players).setMax(arg_0));
        mini.motd(motd -> response.setDescription(SpongeComponentSerializer.get().serialize((Component)motd)));
        mini.icon(arg_0 -> ((ClientPingServerEvent.Response)response).setFavicon(arg_0));
        if (mini.disablePlayerListHover()) {
            players.getProfiles().clear();
        }
        if (mini.hidePlayerCount()) {
            response.setHidePlayers(true);
        }
    }
}

